# TOC

- [DB図](#DB図)
- [テーブル詳細](#テーブル詳細)
    * [users](#users)
    * [tasks](#tasks)
    * [annotations](#annotations)
    * [users_tasks](#users_tasks)
    * [users_annotations](#users_annotations)
    * [user_annotations_logs](#user_annotations_logs)

# DB図
<img src="https://github.com/CyberAgent/fast-annotation-tool/blob/master/docs/imgs/db_latest.png" alt="image" width=700 />

# テーブル詳細

## users

ユーザ情報

| name       | type                              | example                   | comment |
| ---------- | --------------------------------- | ------------------------- | ------- |
| id         | string (unique)                   | 123hoge                   |         |
| name       | string                            | 山田太郎                  |         |
| email      | string                            | dews(at)gmail.com         |         |
| role       | role_type: "admin" \| "annotator" | admin                     |         |
| photo_url  | string                            | http(s)://dews.png        |         |
| created_at | timestamp                         | 2020/01/01 10:00:00 UTC+9 |         |
| updated_at | timestamp                         | 2020/01/01 10:00:00 UTC+9 |         |




## tasks

タスク情報


| name            | type                                     | example                                                  | comment                                      |
| --------------- | ---------------------------------------- | -------------------------------------------------------- | -------------------------------------------- |
| id              | string (unique)                          | person-main6cat-20201007                                 |                                              |
| annotation_type | annotation_type: "card" \| "multi_label" | card                                                     | どのアノテーションUIを使うか。               |
| title           | string                                   | 人名（主要カテゴリ）                                     | タスク一覧画面で表示するタスクのタイトル。   |
| description     | string                                   | 広告文内の太字が人名かどうかを判断するアノテーションです | タスク一覧画面で表示するタスクの細かい説明。 |
| question        | string                                   | `<b>太字部分</b>は<b>人名</b>ですか？`                   | アノテーション画面で表示する質問文。         |
| created_at      | timestamp                                | 2020/01/01 10:00:00 UTC+9                                |                                              |
| updated_at      | timestamp                                | 2020/01/01 10:00:00 UTC+9                                |                                              |



## annotations

実際のアノテーション用データ

| name       | type            | example                                                      | comment                                                      |
| ---------- | --------------- | ------------------------------------------------------------ | ------------------------------------------------------------ |
| id         | string (unique) | hoge123                                                      |                                                              |
| task_id    | string          | person-main6cat-20201007                                     |                                                              |
| data       | dict            | `{"text": "<b>松本伊代</b>が20年愛用するミルク液がやばい","cand_entity": "松本伊代", "show_ambiguous_button": true}` | アノテーションデータの中身。メタ的な情報も含む。tasks.annotation_typeに依存. |
| created_at | timestamp       | 2020/01/01 10:00:00 UTC+9                                    |                                                              |
| updated_at | timestamp       | 2020/01/01 10:00:00 UTC+9                                    |                                                              |

annotations.data のスキーマは [[タスク依存のスキーマ]] へ。



## users_tasks

実際にユーザに振り分けられたタスクを表す。

| name           | type            | example                   | comment                                |
| -------------- | --------------- | ------------------------- | -------------------------------------- |
| id             | string (unique) | hoge123                   |                                        |
| user_id        | string          | hoge123                   |                                        |
| task_id        | string          | person-main6cat-20201007  |                                        |
| annotation_num | int             | 1000                      | ユーザに割り当てられたアノテーション数 |
| submitted_num  | int             | 10                        | ユーザが何個アノテーションしたか       |
| created_at     | timestamp       | 2020/01/01 10:00:00 UTC+9 |                                        |
| updated_at     | timestamp       | 2020/01/01 10:00:00 UTC+9 |                                        |

- 基本的にアノテーション数などの集計結果を保持する。



## users_annotations

実際にユーザに振り分けられたアノテーションを表す。


| name          | type            | example                   | comment                                                      |
| ------------- | --------------- | ------------------------- | ------------------------------------------------------------ |
| id            | string (unique) | hoge123                   |                                                              |
| user_id       | string          | hoge123                   |                                                              |
| annotation_id | string          | hoge123                   |                                                              |
| user_task_id  | string          | hoge123                   |                                                              |
| order_index   | int             | 20                        | アノテーションの順番を表す。1 <= order_index <= users_tasks.annotation_num |
| result_data   | dict            | `{"result": "Yes"}`       | ユーザの回答。tasks.annotation_typeに依存。                  |
| created_at    | timestamp       | 2020/01/01 10:00:00 UTC+9 |                                                              |
| updated_at    | timestamp       | 2020/01/01 10:00:00 UTC+9 |                                                              |

users_annotations.result_data のスキーマは [[タスク依存のスキーマ]] へ。



## user_annotations_logs

ユーザがアノテーション時に行ったアクションのログ


| name               | type                                  | example                   | comment                  |
| ------------------ | ------------------------------------- | ------------------------- | ------------------------ |
| id                 | string (unique)                       | hoge123                   |                          |
| user_task_id       | string                                | hoge123                   |                          |
| user_annotation_id | string                                | hoge123                   |                          |
| action_type        | "display", "select", "submit", "back" | select                    | アクションの種類         |
| action_data        | dict                                  | {'choice': 'hoge'}        | アクション時の詳細データ |
| created_at         | timestamp                             | 2020/01/01 10:00:00 UTC+9 |                          |