[English](Quick-Start) | **日本語**

## Requirement

- [Docker/Docker Compose](https://docs.docker.com/get-docker/)
- [Google Cloud SDK](https://cloud.google.com/sdk/docs/install)
- [Firebase CLI](https://firebase.google.com/docs/cli#install-cli-mac-linux)

## 1. Firebase プロジェクトの作成

右リンクより作成：https://console.firebase.google.com/

## 2. プロジェクトの設定

```shell
# gcloud ログイン
gcloud auth login
# 必要な api の有効化
gcloud services enable firestore.googleapis.com run.googleapis.com cloudbuild.googleapis.com
```

```shell
# Firebase ログイン
firebase login
# プロジェクトの確認
firebase projects:list
# 対象プロジェクトの設定
cd frontend/app
firebase use --add <PROJECT_ID> --alias default
# Firebase Webアプリの作成
firebase apps:create WEB <APP_NAME>
```
- `分析 > Dashboard` から Analytics を有効化

<details>
<summary> <code>Firestore Database</code> から Nativeモードに変更</summary>
<img src="https://user-images.githubusercontent.com/17490886/120969770-859b2280-c7a5-11eb-95c8-4bfae69ad3b2.png" alt="image" width=700 /><br/>
<img src="https://user-images.githubusercontent.com/17490886/120969765-83d15f00-c7a5-11eb-94f1-f0425b521db7.png" alt="image" width=1000 />
</details>

<details>
<summary> <code>プロジェクトの設定 > デフォルトの GCP リソース ロケーション</code> から デフォルトのリソースロケーションを設定</summary>
<img src="https://user-images.githubusercontent.com/17490886/120323346-5e190580-c320-11eb-8227-074ce8e1ca0a.png" alt="image" width=500 />
</details>

<details>
<summary> <code>Authentication > Sign-in method</code> のログイン プロバイダで Google を有効化</summary>
<img src="https://camo.githubusercontent.com/9a3cf556bd1e801a1c9ef89c0bf92a3a72c75d2087cdda3035b95dc97162dd5b/68747470733a2f2f747661312e73696e61696d672e636e2f6c617267652f30303753385a496c677931676a3930636e316376756a3330727a3064317133732e6a7067" alt="image-20200930224109605" width=600 />
</details>

<details>
<summary> <a href='https://console.cloud.google.com/cloud-build/settings'>Cloud Build 設定ページ</a> より Cloud Run と Service Accounts を有効化</summary>
<img src="https://tva1.sinaimg.cn/large/008i3skNgy1gr3t6rqqa2j30nd0dpjtr.jpg" alt="image-20210602132610249" width=500 />
</details>
  


## 3. Backend

`backend/cloud-run-api` に移動

- `.env.example` を参考に `.env`を設定

```
GOOGLE_APPLICATION_CREDENTIALS=/root/.config/gcloud/application_default_credentials.json
GOOGLE_CLOUD_PROJECT=<PROJECT_ID>
API_VERSION=1.0.0
API_PROJECT_NAME=fast-annotation-tool-api
APP_URL=https://<PROJECT_ID>.web.app
```

### 3.1 ローカル環境でのAPI起動

以下のコマンドを実行すると、APIサーバ（ http://localhost:5000/ ）と検証用のJupyterサーバ（ http://localhost:8888/ ）が起動します。

APIの使い方は [こちらのnotebook](https://github.com/CyberAgent/fast-annotation-tool/blob/master/backend/cloud-run-api/notebooks/QuickStart-API.ipynb) を参考にしてください。

```shell
gcloud auth application-default login
make up
```

### 3.2 デモデータの流し込み

動作確認用のデモデータを FireStore に流し込みます

```shell
make set_demo_tasks
```

### 3.3 Admin権限の付与

ユーザにAdmin権限を付与します。Adminユーザはアプリ上でタスクの振り分けや進捗確認ができます。  
（フロントアプリ上でログイン後に実行してください）

```shell
make set_user_role email=<YOUR_EMAIL> role=admin
```

### 3.4 デプロイ

Cloud Run にデプロイします。

```shell
gcloud builds submit --substitutions _PROJECT=<PROJECT_ID>,_APP_URL=<PROJECT_ID>.web.app
```


## 4. Frontend

`frontend` に移動

- `.env.example` を参考に `.env`を設定
  - REACT_APP_* 系 は `firebase apps:sdkconfig` から取得
  - FIREBASE_TOKEN は `firebase login:ci `で取得

```
REACT_APP_DEV_PORT=8080
REACT_APP_PRD_PORT=3000
FIREBASE_TOKEN=*****
REACT_APP_FIREBASE_API_KEY=*****
REACT_APP_FIREBASE_AUTH_DOMAIN=<PROJECT_ID>.firebaseapp.com
REACT_APP_FIREBASE_PROJECT_ID=<PROJECT_ID>
REACT_APP_FIREBASE_MESSAGING_SENDER_ID=*****
REACT_APP_FIREBASE_APP_ID=*****
REACT_APP_MEASUREMENT_ID=*****
```

### 4.1 初期化

```shell
make init
```

### 4.2 ローカル環境でのアプリ起動

以下のコマンドを実行してから、http://localhost:8080/ にアクセスしてください。

```shell
make up
```

### 4.3 デプロイ

アプリをビルドし Firebase Hosting にデプロイします。
デプロイ後 `<PROJECT_ID>.web.app` で動作確認ができます。

```shell
make deploy
```

### 4.4 タスクの振り分け

`3.3 Admin権限の付与` にて Admin 権限を付与したユーザでアプリにログインし、メニューからタスク管理画面に飛んでください。`3.2 デモデータの流し込み` で追加したタスクが確認できます。

![image-20210603000225317](https://tva1.sinaimg.cn/large/008i3skNgy1gr4bk9ofvhj31a20kg0uz.jpg)

タスク詳細ページに飛び、未振り分けユーザを選択し、振り分けを実行すると、
ユーザのメインページにタスクが追加されます。

<img src="https://tva1.sinaimg.cn/large/008i3skNgy1gr4foo11c8j30ko10y0u8.jpg" alt="image-20210603022422501" width=300 />

