import React, { Component } from 'react';
import { Meteor } from 'meteor/meteor';

export default class Label extends Component {
  constructor(props) {
    super(props);

    this.mouseEnter = this.mouseEnter.bind(this);
    this.mouseLeave = this.mouseLeave.bind(this);
    this.mouseDown = this.mouseDown.bind(this);
    this.mouseUp = this.mouseUp.bind(this);

    this.state = {
      selected: false,
    };
  }

  mouseEnter = (e) => {
    if (! this.props.readOnly) {
      this.setState({
        selected: true,
      });
    }
  }
  mouseLeave = (e) => {
    if (! this.props.readOnly) {
      this.setState({
        selected: false,
      });
    }
  }
  mouseDown = (e) => {
    if (! this.props.readOnly) {
      this.props.onMouseDown(this.props.label, this.props.mention, e.shiftKey, e.altKey);
    }
    e.stopPropagation();
  }
  mouseUp = (e) => {
    if (! this.props.readOnly) {
      this.props.onMouseUp(this.props.label, this.props.mention, e.shiftKey, e.altKey);
    }
    e.stopPropagation();
  }

  render() {
    const label = this.props.label;
    var labelText = label;
    if (label.includes("::")) {
      labelText = labelText.split("::")[0];
    }
    const mention = this.props.mentionMap[this.props.mention.start].find(pair => {
      return pair.mention.end == this.props.mention.end && pair.mention.start == this.props.mention.start && pair.mention.label == this.props.mention.label;
    });
    var divStyle = this.state.selected || this.props.isChosen ? this.props.altStyle : this.props.style;
    if (mention.hint.startsWith("wrong-label")) {
      if (mention.hint.endsWith(label)) {
        divStyle = {
          borderColor: "#1b9e77",
          backgroundColor: (!this.state.selected) ? "#1b9e77" : "#f0fff4",
          color: (!this.state.selected) ? 'white' : 'black',
        };
      } else {
        divStyle = {
          borderColor: "#d95f02",
          backgroundColor: (!this.state.selected) ? "#d95f02" : "#fff0f1",
          color: (!this.state.selected) ? 'white' : 'black',
        };
      }
    }

    return [
      this.props.isFirst ? "" : (<div key="1" className="clear"></div>),
      (<span 
        key={label}
        className={"mention-label noselect"}
        onMouseEnter={this.mouseEnter}
        onMouseLeave={this.mouseLeave}
        onMouseDown={this.mouseDown}
        onMouseUp={this.mouseUp}
        style={divStyle}
      >{labelText}</span>),
    ];
  }
}
