HRG parsing with deepbank.


# Grammer Extraction

EDS:

```python
from coli.hrgguru.extract_sync_grammar import ExtractionParams, SyncGrammarExtractor
from coli.hrgguru.hrg import HRGDerivation
from coli.hrgguru.strip_utils import STRIP_ALL_LABELS

deepbank_export_path = "../large-data/hrg/deepbank_export_1.1/"
params = ExtractionParams(strip_tree=STRIP_ALL_LABELS,
                               detect_func=HRGDerivation.detect_small,
                               graph_type="eds",
                               )
for mode in ("dev", "test", "train"):
    main_dir = "../large-data/hrg/java_out_" + mode + "/"
    extractor = SyncGrammarExtractor(deepbank_export_path)
    extractor.extract(main_dir, "deepbank1.1-eds-180912", params, mode)
```
