from typing import TypeVar, Mapping, Dict, Set, Iterable

KT = TypeVar("KT")
VT = TypeVar("VT")


def maximum_match(links: Mapping[KT, Iterable[VT]]) -> Dict[VT, KT]:
    max_match: Dict[VT, KT] = {}
    used: Set[VT] = set()
    match_count = 0

    def find(source):
        for target in links[source]:
            if target not in used:
                used.add(target)
                if target not in max_match or find(max_match[target]):
                    max_match[target] = source
                    return True
        return False

    for i in links.keys():
        used.clear()
        if find(i):
            match_count += 1

    return max_match
