/*
 * Decompiled with CFR 0.152.
 */
package sdp.io;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import sdp.graph.Edge;
import sdp.graph.Graph;
import sdp.graph.Node;

public class GraphWriter {
    private final PrintWriter writer;

    public GraphWriter(PrintWriter writer) {
        this.writer = writer;
    }

    public GraphWriter(File file) throws IOException {
        this(new PrintWriter(new BufferedWriter(new FileWriter(file))));
    }

    public GraphWriter(String fileName) throws IOException {
        this(new File(fileName));
    }

    public void writeGraph(Graph graph) throws IOException {
        int nNodes = graph.getNNodes();
        String[][] labels = new String[nNodes][nNodes];
        for (Edge edge : graph.getEdges()) {
            labels[edge.source][edge.target] = edge.label;
        }
        this.writer.println(graph.id);
        for (Node node : graph.getNodes()) {
            if (node.id <= 0) continue;
            StringBuilder sb = new StringBuilder();
            sb.append(Integer.toString(node.id));
            sb.append("\t");
            sb.append(node.form);
            sb.append("\t");
            sb.append(node.lemma);
            sb.append("\t");
            sb.append(node.pos);
            sb.append("\t");
            sb.append(node.isTop ? "+" : "-");
            sb.append("\t");
            sb.append(node.isPred ? "+" : "-");
            for (Node source : graph.getNodes().subList(1, nNodes)) {
                if (!source.isPred) continue;
                sb.append("\t");
                String label = labels[source.id][node.id];
                if (label == null) {
                    sb.append("_");
                    continue;
                }
                sb.append(label);
            }
            this.writer.println(sb.toString());
        }
        this.writer.println();
    }

    public void close() throws IOException {
        this.writer.close();
    }
}

