/*
 * Decompiled with CFR 0.152.
 */
package sdp.graph;

import java.util.LinkedList;
import java.util.List;
import sdp.graph.Edge;

public class Node {
    public final int id;
    public final List<Edge> incomingEdges;
    public final List<Edge> outgoingEdges;
    public final String form;
    public final String lemma;
    public final String pos;
    public final boolean isTop;
    public final boolean isPred;

    public Node(int id, String form, String lemma, String pos, boolean isTop, boolean isPred) {
        this.id = id;
        this.incomingEdges = new LinkedList<Edge>();
        this.outgoingEdges = new LinkedList<Edge>();
        this.form = form;
        this.lemma = lemma;
        this.pos = pos;
        this.isTop = isTop;
        this.isPred = isPred;
    }

    public Edge addIncomingEdge(Edge edge) {
        this.incomingEdges.add(edge);
        return edge;
    }

    public boolean hasIncomingEdges() {
        return !this.incomingEdges.isEmpty();
    }

    public int getNIncomingEdges() {
        return this.incomingEdges.size();
    }

    public List<Edge> getIncomingEdges() {
        return this.incomingEdges;
    }

    public Edge addOutgoingEdge(Edge edge) {
        this.outgoingEdges.add(edge);
        return edge;
    }

    public boolean hasOutgoingEdges() {
        return !this.outgoingEdges.isEmpty();
    }

    public int getNOutgoingEdges() {
        return this.outgoingEdges.size();
    }

    public List<Edge> getOutgoingEdges() {
        return this.outgoingEdges;
    }
}

