#include "manager.hpp"

using namespace shrg;

int main(int argc, char *argv[]) {
    auto &manager = Manager::manager;
    manager.Allocate(1);

    if (argc != 4) {
        LOG_ERROR("Usage: shrg_parser <parser_type> <grammar_path> <graph_path>");
        return 1;
    }

    manager.LoadGrammars(argv[2]);
    manager.LoadGraphs(argv[3]);

    auto &context = manager.contexts[0];
    context->Init(argv[1], true /* verbose */, 100 /* pool_size */);

    for (auto &graph : manager.edsgraphs) {
        auto code = context->Parse(graph);

        std::cout << graph.sentence_id << "\n>>>>> ";
        if (code == ParserError::kNone) {
            context->Generate();
            debug::Printer printer{nullptr, manager.label_set};
            printer.Ln(context->derivation, context->derivation[0], 0, std::cout << '\n');
        } else
            std::cout << ToString(code);
        std::cout << std::endl;
    }

    return 0;
}
