# -*- coding: utf-8 -*-

"""
longest common subsequence
modified from the code snippets at
http://en.wikibooks.org/wiki/Algorithm_Implementation/Strings/Longest_common_subsequence#Python
cython -a lcs.pyx to output HTML
"""
import numpy as np

cimport cython
cimport numpy as np

cdef inline int int_max(int a, int b): return a if a >= b else b


@cython.boundscheck(False)
def longest_common_subsequence(X, Y, return_path: bool=False):
    """Compute and return the longest common subsequence matrix X, Y are list of strings"""
    cdef int m = len(X)
    cdef int n = len(Y)

    # use numpy array for memory efficiency with long sequences
    # lcs is bounded above by the minimum length of x, y
    assert min(m + 1, n + 1) < 65535

    cdef np.ndarray[np.uint16_t, ndim= 2] dp = np.zeros([m + 1, n + 1], dtype=np.uint16)

    cdef int i = 0, j = 0, v = 0
    for i in range(1, m + 1):
        for j in range(1, n + 1):
            dp[i, j] = int_max(dp[i, j - 1], dp[i - 1, j])

            v = dp[i - 1, j - 1] + 1
            if X[i - 1] == Y[j - 1] and dp[i, j] < v:
                dp[i, j] = v

    if not return_path:
        return dp

    pairs = []
    while i > 0 and j > 0:
        v = dp[i, j]
        if v == dp[i - 1, j]:
            i -= 1
        elif v == dp[i, j - 1]:
            j -= 1
        else:
            assert v == dp[i - 1, j - 1] + 1
            j -= 1
            i -= 1
            pairs.append((i, j))

    pairs.reverse()
    return pairs
