/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees.tregex;

import edu.stanford.nlp.stats.IntCounter;
import edu.stanford.nlp.util.Generics;
import java.util.Map;

class VariableStrings {
    private final Map<String, String> varsToStrings = Generics.newHashMap();
    private final IntCounter<String> numVarsSet = new IntCounter();

    public boolean isSet(String o) {
        return this.numVarsSet.getCount(o) >= 1.0;
    }

    public void setVar(String var, String string) {
        String oldString = this.varsToStrings.put(var, string);
        if (oldString != null && !oldString.equals(string)) {
            throw new RuntimeException("Error -- can't setVar to a different string -- old: " + oldString + " new: " + string);
        }
        this.numVarsSet.incrementCount(var);
    }

    public void unsetVar(String var) {
        if (this.numVarsSet.getCount(var) > 0.0) {
            this.numVarsSet.decrementCount(var);
        }
        if (this.numVarsSet.getCount(var) == 0.0) {
            this.varsToStrings.put(var, null);
        }
    }

    public String getString(String var) {
        return this.varsToStrings.get(var);
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append("{");
        boolean appended = false;
        for (String key : this.varsToStrings.keySet()) {
            if (appended) {
                s.append(",");
            } else {
                appended = true;
            }
            s.append(key);
            s.append("=(");
            s.append(this.varsToStrings.get(key));
            s.append(":");
            s.append(this.numVarsSet.getCount(key));
            s.append(")");
        }
        s.append("}");
        return s.toString();
    }
}

