/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.ling.tokensregex;

import edu.stanford.nlp.ling.tokensregex.BasicSequenceMatchResult;
import edu.stanford.nlp.ling.tokensregex.SequenceMatchResult;
import edu.stanford.nlp.ling.tokensregex.SequenceMatcher;
import edu.stanford.nlp.ling.tokensregex.SequencePattern;
import edu.stanford.nlp.util.Function;
import edu.stanford.nlp.util.IntervalTree;
import edu.stanford.nlp.util.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;

public class MultiPatternMatcher<T> {
    Collection<SequencePattern<T>> patterns;
    SequencePatternTrigger<T> patternTrigger;

    public MultiPatternMatcher(SequencePatternTrigger<T> patternTrigger, Collection<? extends SequencePattern<T>> patterns) {
        this.patterns = new ArrayList<SequencePattern<T>>();
        this.patterns.addAll(patterns);
        this.patternTrigger = patternTrigger;
    }

    public MultiPatternMatcher(SequencePatternTrigger<T> patternTrigger, SequencePattern<T> ... patterns) {
        this(patterns);
        this.patternTrigger = patternTrigger;
    }

    public MultiPatternMatcher(Collection<SequencePattern<T>> patterns) {
        this.patterns = patterns;
    }

    public MultiPatternMatcher(SequencePattern<T> ... patterns) {
        this.patterns = new ArrayList<SequencePattern<T>>(patterns.length);
        for (SequencePattern<T> p : patterns) {
            this.patterns.add(p);
        }
    }

    public List<SequenceMatchResult<T>> findNonOverlapping(List<? extends T> elements) {
        return this.findNonOverlapping(elements, SequenceMatchResult.DEFAULT_COMPARATOR);
    }

    public List<SequenceMatchResult<T>> findNonOverlapping(List<? extends T> elements, Comparator<? super SequenceMatchResult> cmp) {
        Collection<SequencePattern<T>> triggered = this.getTriggeredPatterns(elements);
        ArrayList<BasicSequenceMatchResult<? extends T>> all = new ArrayList<BasicSequenceMatchResult<? extends T>>();
        int i = 0;
        for (SequencePattern<? extends T> sequencePattern : triggered) {
            SequenceMatcher<T> m = sequencePattern.getMatcher(elements);
            m.setOrder(i);
            while (m.find()) {
                all.add(m.toBasicSequenceMatchResult());
            }
            ++i;
        }
        List<SequenceMatchResult<T>> res = IntervalTree.getNonOverlapping(all, SequenceMatchResult.TO_INTERVAL, cmp);
        Collections.sort(res, SequenceMatchResult.OFFSET_COMPARATOR);
        return res;
    }

    public Iterable<SequenceMatchResult<T>> findAllNonOverlappingMatchesPerPattern(List<? extends T> elements) {
        Collection<SequencePattern<T>> triggered = this.getTriggeredPatterns(elements);
        ArrayList<Iterable<SequenceMatchResult<? extends T>>> allMatches = new ArrayList<Iterable<SequenceMatchResult<? extends T>>>(elements.size());
        for (SequencePattern<T> p : triggered) {
            Iterable<SequenceMatchResult<? extends T>> matches = p.getMatcher(elements).findAllNonOverlapping();
            allMatches.add(matches);
        }
        return Iterables.chain(allMatches);
    }

    public Collection<SequencePattern<T>> getTriggeredPatterns(List<? extends T> elements) {
        if (this.patternTrigger != null) {
            return (Collection)this.patternTrigger.apply(elements);
        }
        return this.patterns;
    }

    public static class BasicSequencePatternTrigger<T>
    implements SequencePatternTrigger<T> {
        NodePatternTrigger<T> trigger;

        public BasicSequencePatternTrigger(NodePatternTrigger<T> trigger) {
            this.trigger = trigger;
        }

        @Override
        public Collection<SequencePattern<T>> apply(List<? extends T> elements) {
            LinkedHashSet<SequencePattern<T>> triggeredPatterns = new LinkedHashSet<SequencePattern<T>>();
            for (T node : elements) {
                Collection triggered = (Collection)this.trigger.apply(node);
                triggeredPatterns.addAll(triggered);
            }
            return triggeredPatterns;
        }
    }

    public static interface SequencePatternTrigger<T>
    extends Function<List<? extends T>, Collection<SequencePattern<T>>> {
    }

    public static interface NodePatternTrigger<T>
    extends Function<T, Collection<SequencePattern<T>>> {
    }
}

