/*
 * Decompiled with CFR 0.152.
 */
package matetools.is2.parserR2;

import matetools.is2.util.OptionsSuper;

public final class Options
extends OptionsSuper {
    int start = 0;
    int end = 0;
    String prefix_model = "m";
    String prefix_test = "t";

    public Options(String[] args) {
        int i = 0;
        while (i < args.length) {
            if (args[i].equals("--help")) {
                this.explain();
            }
            if (args[i].equals("-decode")) {
                this.decodeProjective = args[i + 1].equals("proj");
                ++i;
            } else if (args[i].equals("-decodeTH")) {
                this.decodeTH = Double.parseDouble(args[i + 1]);
                ++i;
            } else if (args[i].equals("-nonormalize")) {
                this.normalize = false;
            } else if (args[i].equals("-features")) {
                this.features = args[i + 1];
                ++i;
            } else if (args[i].equals("-hsize")) {
                this.hsize = Integer.parseInt(args[i + 1]);
                ++i;
            } else if (args[i].equals("-len")) {
                this.maxLen = Integer.parseInt(args[i + 1]);
                ++i;
            } else if (args[i].equals("-cores")) {
                this.cores = Integer.parseInt(args[i + 1]);
                ++i;
            } else if (args[i].equals("-best")) {
                this.best = Integer.parseInt(args[i + 1]);
                ++i;
            } else if (args[i].equals("-start")) {
                this.start = Integer.parseInt(args[i + 1]);
                ++i;
            } else if (args[i].equals("-end")) {
                this.end = Integer.parseInt(args[i + 1]);
                ++i;
            } else if (args[i].equals("-prefix-model")) {
                this.prefix_model = args[i + 1];
                ++i;
            } else if (args[i].equals("-prefix-test")) {
                this.prefix_test = args[i + 1];
                ++i;
            } else if (args[i].equals("-mapping")) {
                this.useMapping = args[i + 1];
                ++i;
            } else if (args[i].equals("-no2nd")) {
                this.no2nd = true;
            } else if (args[i].equals("-few2nd")) {
                this.few2nd = true;
            } else {
                super.addOption(args, i);
            }
            ++i;
        }
    }

    private void explain() {
        System.out.println("Usage: ");
        System.out.println("java -class mate.jar is2.parser.Parser [Options]");
        System.out.println();
        System.out.println("Example: ");
        System.out.println(" java -class mate.jar is2.parser.Parser -model eps3.model -train corpora/conll08st/train/train.closed -test corpora/conll08st/devel/devel.closed  -out b3.test -eval corpora/conll08st/devel/devel.closed  -count 2000 -i 6");
        System.out.println("");
        System.out.println("Options:");
        System.out.println("");
        System.out.println(" -train  <fname>    the corpus a model is trained on; default " + this.trainfile);
        System.out.println(" -test   <fname>    the input corpus for testing; default " + this.testfile);
        System.out.println(" -out    <fname>    the output corpus (result) of a test run; default " + this.outfile);
        System.out.println(" -model  <fname>    the parsing model for traing the model is stored in the files");
        System.out.println("                   and for parsing the model is load from this fname; default " + this.modelName);
        System.out.println(" -i      <number>  the number of training iterations; good numbers are 10 for smaller corpora and 6 for bigger; default " + this.numIters);
        System.out.println(" -count  <number>  the n first sentences of the corpus are take for the training default " + this.count);
        System.out.println(" -format <number>  conll format of the year 8 or 9; default " + this.formatTask);
        System.exit(0);
    }
}

