/*
 * Decompiled with CFR 0.152.
 */
package fig.record;

import fig.record.LoadFileState;
import fig.record.PathRecordNode;
import fig.record.RecordNode;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;

public class DirRecordNode
extends PathRecordNode {
    private boolean isLoading;

    public DirRecordNode(LoadFileState state, File path) {
        super(state, path);
    }

    public DirRecordNode(LoadFileState state, String key, String value, File path) {
        super(state, key, value, path);
    }

    @Override
    public void loadChildren() {
        String[] names;
        if (this.isLoading) {
            return;
        }
        this.isLoading = true;
        HashMap<String, RecordNode> currNodes = new HashMap<String, RecordNode>();
        for (RecordNode child : this.getChildren()) {
            currNodes.put(child.getKey(), child);
        }
        ArrayList<RecordNode> newChildren = new ArrayList<RecordNode>();
        String[] stringArray = names = this.getPath().list();
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            RecordNode node = (RecordNode)currNodes.get(name);
            if (node == null) {
                node = DirRecordNode.newPathNode(this, this.state, name);
            }
            if (node != null) {
                newChildren.add(node);
            }
            ++n2;
        }
        this.setChildren(newChildren);
        super.loadChildren();
        this.isLoading = false;
    }

    @Override
    public RecordNode shallowCopy(String key, String value) {
        DirRecordNode node = new DirRecordNode(this.state, key, value, this.getPath());
        node.setChildren(this.getChildren());
        return node;
    }

    @Override
    public RecordNode withoutChildren() {
        return new DirRecordNode(this.state, this.getPath()).disableLoading();
    }

    @Override
    public String getDescription(RecordNode.DescriptionType type) {
        if (type == RecordNode.DescriptionType.human) {
            return super.getDescription(type);
        }
        return ".dir\t" + this.getPath() + (this.getValue() == null ? "" : "\t" + this.getValue());
    }
}

