# # Evaluation
root_dir=`dirname $0`/..

## Software bins
metric_path=$root_dir/readability
sacrebleu_path=$root_dir/sockeye/contrib/sacrebleu
moses_scripts_path=$root_dir/moses-scripts
bpe_scripts_path=$root_dir/subword-nmt/subword_nmt
kenlm_path=$root_dir/kenlm/build/bin

id=2

while getopts "i:" opt; do
	case $opt in
		i)
			id=$OPTARG ;;
		h)
			echo "Usage: evaluate.sh"
			echo "-i Run id"
			exit 0 ;;

    \?)
		echo "Invalid option: -$OPTARG" >&2
		exit 1 ;;
    :)
		echo "Option -$OPTARG requires an argument." >&2
		exit 1 ;;
	esac
done

exp_dir=$root_dir/experiments/iter-$id
sub_data_dir=$exp_dir/data
data_dir=$root_dir/data

type_1=src
type_2=tgt

echo " * Adding monolingual spanish data to test.src and test.tgt with grade level.* ..."
# cat $data_dir/test_es.src >> $sub_data_dir/test.src
sed -e "s/^/<2eng>\t/"  $data_dir/test_en.src >> $sub_data_dir/test.src
cat $data_dir/test_en.tgt >> $sub_data_dir/test.tgt

echo " * Adding bilingual indomain equivalent grade data to test.src and test.tgt with grade level.* ..."
# cat $data_dir/test_enes_eq.$type_1 |  sed 's/^<\w*>\t\ *//' >> $sub_data_dir/test.src
sed -e "s/^/<2esp>\t/"  $data_dir/test_enes_eq.$type_1 |  sed 's/^<\w*>\t\ *//' >> $sub_data_dir/test.src
cat $data_dir/test_enes_eq.$type_2 |  sed 's/^<\w*>\t\ *//' >> $sub_data_dir/test.tgt

echo " * Adding bilingual indomain not equivalent grade data to test.src and test.tgt with grade level.* ..."
# cat $data_dir/test_enes_neq.$type_1  >> $sub_data_dir/test.src
sed -e "s/^/<2esp>\t/"  $data_dir/test_enes_neq.$type_1  >> $sub_data_dir/test.src
cat $data_dir/test_enes_neq.$type_2  >> $sub_data_dir/test.tgt


echo " * Translating test sentences.* ..."
test_dir=$exp_dir/test-$id
model_dir=$exp_dir/model-$id
mkdir -p $test_dir
test_src=$sub_data_dir/test.src
. $root_dir/scripts/translate.sh

echo " * Evalutaing the model for run id $id* ..." 
test_src=$sub_data_dir/test.src
test_ref=$sub_data_dir/test.tgt
test_pred=$test_dir/test.trans.detok


# Separate english, eq, neq data
config_file=$exp_dir/config
echo $config_file
. $config_file


start=1
count=($(wc -l $root_dir/data/test_en.src))
end=$(($start+$count-1));
echo "Evaluating on monolingual data: $start:$end"
sed "$start,$end !d" < $test_src > $test_dir/test_es.src
sed "$start,$end !d" < $test_ref > $test_dir/test_es.tgt
sed "$start,$end !d" < $test_pred > $test_dir/test_es.pred
src=$test_dir/test_es.src 
tgt=$test_dir/test_es.tgt 
pred=$test_dir/test_es.pred 
start=$(($end+1));
k=1
. $root_dir/scripts/compute_metric.sh 

count=($(wc -l $root_dir/data/test_enes_eq.src))
end=$(($start+$count-1));
echo "Evaluating on translation data:  $start:$end"
sed "$start,$end !d" < $test_src > $test_dir/test_enes_eq.src
sed "$start,$end !d" < $test_ref > $test_dir/test_enes_eq.tgt
sed "$start,$end !d" < $test_pred > $test_dir/test_enes_eq.pred
src=$root_dir/experiments/iter-2/test-2/test_enes_eq.pred
tgt=$test_dir/test_enes_eq.tgt 
pred=$test_dir/test_enes_eq.pred 
start=$(($end+1));
k=2
. $root_dir/scripts/compute_metric.sh


count=($(wc -l $root_dir/data/test_enes_neq.src))
end=$(($start+$count-1));
echo "Evaluating on GSMT data:  $start:$end"
sed "$start,$end !d" < $test_src > $test_dir/test_enes_neq.src
sed "$start,$end !d" < $test_ref > $test_dir/test_enes_neq.tgt
sed "$start,$end !d" < $test_pred > $test_dir/test_enes_neq.pred
src=$root_dir/experiments/iter-2/test-2/test_enes_neq.pred
tgt=$test_dir/test_enes_neq.tgt 
pred=$test_dir/test_enes_neq.pred 
start=$(($end+1));
k=3
. $root_dir/scripts/compute_metric.sh


rm $sub_data_dir/test.src
rm $sub_data_dir/test.tgt
