from arguments import get_args
from model import load_model
import os
os.environ['CUDA_LAUNCH_BLOCKING'] = "1"


def main():
    """
    主函数，负责加载模型、获取参数和启动任务。
    
    1. 首先调用get_args函数获取命令行参数，包括模型路径、任务名称等。
    2. 然后使用load_model函数加载指定的模型，并将其保存在变量cov_rag中。
    3. 根据任务名称（task），选择不同的评估函数，如果是'nq_open'或者'web_questions'，则调用retrieve_data_single_iter函数进行评估；否则会抛出一个错误信息。
    4. 最后打印'Initialize Done. Start Evaluating...'，表示初始化完成，开始进行评估。
    
    Returns:
        None，该函数没有返回值。
    
    Raises:
        ValueError: 当任务名称不是'nq_open'或者'web_questions'时，会抛出一个ValueError异常。
    """
    args = get_args()
    
    cov_rag = load_model(args)
    
    task = args.task
    if task == 'nq_open':
        from evaluate.eval import retrieve_data_single_iter
    elif task == 'web_questions':
        from evaluate.eval import retrieve_data_single_iter
    else:
        raise "Task Name Error!"
    
    print('Initialize Done. Start Evaluating...')
    result = retrieve_data_single_iter(cov_rag, args)
    print('retrieve_all')

if __name__ == "__main__":
    main()