theory question_23_3
imports Main

begin

typedecl entity
typedecl event

consts
  Hurricane :: "entity ⇒ bool"
  HighWinds :: "event ⇒ bool"
  Has :: "entity ⇒ event ⇒ bool"
  Tornado :: "entity ⇒ bool"

(* Explanation 1: A hurricane is an entity that has high wind speeds. *)
axiomatization where
  explanation_1: "∀x. Hurricane x ⟶ (∃e. HighWinds e ∧ Has x e)"

(* Explanation 2: A tornado is a distinct entity that also has high wind speeds. *)
axiomatization where
  explanation_2: "∀x. Tornado x ⟶ (∃e. HighWinds e ∧ Has x e)"

(* Explanation 3: High wind speeds are a characteristic of both hurricanes and tornadoes. *)
axiomatization where
  explanation_3: "∀e. Hurricane e ∨ Tornado e ⟶ HighWinds e"

theorem hypothesis:
  assumes asm: "Hurricane e ∨ Tornado e"
  (* Hypothesis: Both hurricanes and tornadoes always have high winds. *)
  shows "HighWinds e"
proof -
  assume asm
  then have "Hurricane e ∨ Tornado e" using asm by simp
  then show "HighWinds e"
    apply (rule impI)
     apply (rule explanation_3)
     apply (rule exI)
     apply (rule exI)
    done
qed

end
