theory question_85_0

imports Main

begin

typedecl entity
typedecl event

consts
  PressureReceptors :: "entity ⇒ bool"
  In :: "entity ⇒ entity ⇒ bool"
  Skin :: "entity"
  PacinianCorpuscles :: "entity ⇒ bool"

(* Explanation 1: Pressure receptors are found mainly in the skin. *)
axiomatization where
  explanation_1: "∀x. PressureReceptors x ⟶ In x Skin"

(* Explanation 2: Pacinian corpuscles are pressure receptors. *)
axiomatization where
  explanation_2: "∀x. PacinianCorpuscles x ⟶ PressureReceptors x"

theorem hypothesis:
  assumes asm: "PacinianCorpuscles x"
  (* Hypothesis: Pacinian corpuscles are found mainly in the skin. *)
  shows "In x Skin"
proof -
  have "PressureReceptors x" using asm explanation_2 by blast
  then have "In x Skin" using explanation_1 by blast
  then show ?thesis by simp
qed

end
