theory question_25_10

imports Main

begin

typedecl entity
typedecl event

consts
  Viruses :: "entity ⇒ bool"
  LivingOrganisms :: "entity ⇒ bool"
  Cells :: "entity ⇒ bool"
  Host :: "entity ⇒ bool"
  Infect :: "event ⇒ bool"
  Live :: "event ⇒ bool"
  Release :: "event ⇒ bool"
  Lysing :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"
  (≺) :: "event ⇒ event ⇒ bool"

(* Explanation 1: Viruses infect living organisms and subsequently live inside their cells. *)
axiomatization where
  explanation_1: "∀x y z e1 e2. Viruses x ∧ LivingOrganisms y ∧ Cells z ∧ Infect e1 ∧ Live e2 ∧ Agent e1 x ∧ Patient e1 y ∧ Agent e2 x ∧ Patient e2 z ∧ e1 ≺ e2"

(* Explanation 2: After living inside the cells, viruses release into the host by lysing the cells. *)
axiomatization where
  explanation_2: "∀x y z e1 e2. Viruses x ∧ Host y ∧ Cells z ∧ Release e1 ∧ Lysing e2 ∧ Agent e1 x ∧ Patient e1 y ∧ Agent e2 x ∧ Patient e2 z ∧ e1 ≺ e2"

theorem hypothesis:
  assumes asm: "Viruses x ∧ Host y"
  (* Hypothesis: Viruses first infect, then they release into the host by lysing. *)
  shows "∃e1 e2. Infect e1 ∧ Release e2 ∧ Agent e1 x ∧ Patient e1 y ∧ Agent e2 x ∧ Patient e2 y ∧ Lysing e2 ∧ e1 ≺ e2"
proof -
  {
    assume asm: "Viruses x ∧ Host y"
    from asm have "Viruses x" by simp
    from asm have "Host y" by simp
    from explanation_1[OF this] obtain e1 z where e1: "Infect e1 ∧ Live e1 ∧ Agent e1 x ∧ Patient e1 y ∧ Cells z ∧ Agent e1 x ∧ Patient e1 z ∧ e1 ≺ e2" for e2 by blast
    from explanation_2[OF this] obtain e2 where e2: "Release e2 ∧ Lysing e2 ∧ Agent e2 x ∧ Patient e2 y ∧ e1 ≺ e2" by blast
    have "Agent e1 x ∧ Patient e1 y" using e1 by simp
    have "Agent e2 x ∧ Patient e2 y" using e2 by simp
    have "Infect e1 ∧ Release e2 ∧ Agent e1 x ∧ Patient e1 y ∧ Agent e2 x ∧ Patient e2 y ∧ Lysing e2 ∧ e1 ≺ e2" using e1 e2 by simp
    then show ?thesis using asm by blast
  }
qed

end
