theory question_99_0

imports Main

begin
typedecl entity
typedecl event
consts
  Dog :: "entity ⇒ bool"
  Grass :: "entity ⇒ bool"
  Running :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"
  On :: "entity ⇒ entity ⇒ bool"

(* Explanation 1: A dog could also be running on grass. *)
axiomatization where
  explanation_1: "∃x y e. Dog x ∧ Grass y ∧ Running e ∧ Agent e x ∧ Patient e y"

theorem hypothesis:
  (* Premise: A dog is running on grass. *)
  assumes asm: "Dog x ∧ Grass y ∧ Running e ∧ Agent e x ∧ Patient e y"
  (* Hypothesis: A dog is on the grass. *)
  shows "∃x y. Dog x ∧ Grass y ∧ On x y"
proof -
  from asm have "Dog x" by blast
  from asm have "Grass y" by blast
  from asm have "On x y" using Running_def by blast
  show ?thesis using `Dog x` `Grass y` `On x y` by blast
qed

end
