theory question_57_0

imports Main

begin

typedecl entity
typedecl event
consts
  Worker :: "entity ⇒ bool"
  Statue :: "entity ⇒ bool"
  Walking :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Near :: "event ⇒ entity ⇒ bool"

(* Explanation 1: A worker walking by a statue. *)
axiomatization where
  explanation_1: "∃x y e. Worker x ∧ Statue y ∧ Walking e ∧ Agent e x ∧ Near e y"

theorem hypothesis:
  (* Premise: A maintenance worker walking past a statue. *)
  assumes asm: "MaintenancePerson x ∧ Statue y ∧ Walking e ∧ Agent e x ∧ Past e y"
  (* Hypothesis: A worker walking by a statue. *)
  shows "∃x y e. Worker x ∧ Statue y ∧ Walking e ∧ Agent e x ∧ Near e y"
proof -
  from asm have "MaintenancePerson x" by blast
  then have "Worker x" using explanation_1 by blast
  from asm have "Statue y" by blast
  from asm have "Walking e" by blast
  from asm have "Agent e x" by blast
  from asm have "Past e y" by blast
  then show ?thesis using `Worker x` `Statue y` `Walking e` `Agent e x` `Near e y` by blast
qed

end
