theory question_20_10
imports Main

begin

typedecl entity
typedecl event

consts
  Fur :: "entity ⇒ bool"
  Mammals :: "entity ⇒ bool"
  Found :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"
  Have :: "event ⇒ bool"

(* Explanation 1: Fur is a feature that is found in mammals. *)
axiomatization where
  explanation_1: "∀x y e. Fur x ∧ Mammals y ∧ Found e ∧ Agent e y ∧ Patient e x"

(* Explanation 2: Only mammals have fur. If an entity has fur, it is a mammal and no other entities have fur. *)
axiomatization where
  explanation_2: "∀x y e. Mammals x ∧ Fur y ∧ Have e ∧ Agent e x ∧ Patient e y ∧ (∀z. ¬Mammals z ⟶ (¬Have e ∧ ¬Agent e z ∧ ¬Patient e y))"  

theorem hypothesis:
  assumes asm: "Fur x"
  (* Hypothesis: Fur is unique to mammals. *)
  shows "Mammals x"
proof -
  from asm have "Fur x" by simp
  then obtain y e where e: "Mammals y ∧ Found e ∧ Agent e y ∧ Patient e x" using explanation_1 by blast
  then have "Mammals x" using explanation_2 by blast
  show ?thesis using `Mammals x` by blast
qed

end
