theory question_98_1

imports Main

begin
typedecl entity
typedecl event
consts
  Man :: "entity ⇒ bool"
  Pool :: "entity ⇒ bool"
  Jumping :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Source :: "event ⇒ entity ⇒ bool"
  Young :: "entity ⇒ bool"
  Goggles :: "entity ⇒ bool"
  Wearing :: "entity ⇒ entity ⇒ bool"
  Splashing :: "event ⇒ bool"
  Everywhere :: "event ⇒ bool"

(* Explanation 1: There is both a man jumping out of a pool. *)
axiomatization where
  explanation_1: "∃x y e. Man x ∧ Pool y ∧ Jumping e ∧ Agent e x ∧ Source e y"

theorem hypothesis:
  (* Premise: A young man wearing goggles, is jumping out of a pool, splashing water everywhere. *)
  assumes asm: "Young x ∧ Man x ∧ Goggles y ∧ Pool z ∧ Jumping e ∧ Agent e x ∧ Wearing x y ∧ Source e z ∧ Splashing e ∧ Everywhere e"
  (* Hypothesis: Man jumping out of a pool. *)
  shows "∃x y e. Man x ∧ Pool y ∧ Jumping e ∧ Agent e x ∧ Source e y"
proof -
  from asm have "Young x ∧ Man x ∧ Goggles y ∧ Pool z ∧ Jumping e ∧ Agent e x ∧ Wearing x y ∧ Source e z ∧ Splashing e ∧ Everywhere e" by blast
  then have "Man x ∧ Pool z ∧ Jumping e ∧ Agent e x ∧ Source e z" using explanation_1 by blast
  then show ?thesis using `Man x` `Pool z` `Jumping e` `Agent e x` `Source e z` by blast
qed

end
