SQLITE_KEYWORDS = {
    "SCOL":  ";",
    "DOT":  ".",
    "OPEN_PAR":  "(",
    "CLOSE_PAR":  ")",
    "COMMA":  ",",
    "ASSIGN":  "=",
    "STAR":  "*",
    "PLUS":  "+",
    "MINUS":  "-",
    "TILDE":  "~",
    "PIPE2":  "||",
    "DIV":  "/",
    "MOD":  "%",
    "LT2":  "<<",
    "GT2":  ">>",
    "AMP":  "&",
    "PIPE":  "|",
    "LT":  "<",
    "LT_EQ":  "<=",
    "GT":  ">",
    "GT_EQ":  ">=",
    "EQ":  "==",
    "NOT_EQ1":  "!=",
    "NOT_EQ2":  "<>",
    "ABORT":  "ABORT",
    "ACTION": "ACTION",
    "ADD": "ADD",
    "AFTER": "AFTER",
    "ALL": "ALL",
    "ALTER": "ALTER",
    "ANALYZE": "ANALYZE",
    "AND": "AND",
    "AS": "AS",
    "ASC": "ASC",
    "ATTACH": "ATTACH",
    "AUTOINCREMENT": "AUTOINCREMENT",
    "BEFORE": "BEFORE",
    "BEGIN": "BEGIN",
    "BETWEEN": "BETWEEN",
    "BY": "BY",
    "CASCADE": "CASCADE",
    "CASE": "CASE",
    "CAST": "CAST",
    "CHECK": "CHECK",
    "COLLATE": "COLLATE",
    "COLUMN": "COLUMN",
    "COMMIT": "COMMIT",
    "CONFLICT": "CONFLICT",
    "CONSTRAINT": "CONSTRAINT",
    "CREATE": "CREATE",
    "CROSS": "CROSS",
    "CURRENT_DATE": "CURRENT_DATE",
    "CURRENT_TIME": "CURRENT_TIME",
    "CURRENT_TIMESTAMP": "CURRENT_TIMESTAMP",
    "DATABASE": "DATABASE",
    "DEFAULT": "DEFAULT",
    "DEFERRABLE": "DEFERRABLE",
    "DEFERRED": "DEFERRED",
    "DELETE": "DELETE",
    "DESC": "DESC",
    "DETACH": "DETACH",
    "DISTINCT": "DISTINCT",
    "DROP": "DROP",
    "EACH": "EACH",
    "ELSE": "ELSE",
    "END": "END",
    "ESCAPE": "ESCAPE",
    "EXCEPT": "EXCEPT",
    "EXCLUSIVE": "EXCLUSIVE",
    "EXISTS": "EXISTS",
    "EXPLAIN": "EXPLAIN",
    "FAIL": "FAIL",
    "FOR": "FOR",
    "FOREIGN": "FOREIGN",
    "FROM": "FROM",
    "FULL": "FULL",
    "GLOB": "GLOB",
    "GROUP": "GROUP",
    "HAVING": "HAVING",
    "IF": "IF",
    "IGNORE": "IGNORE",
    "IMMEDIATE": "IMMEDIATE",
    "IN": "IN",
    "INDEX": "INDEX",
    "INDEXED": "INDEXED",
    "INITIALLY": "INITIALLY",
    "INNER": "INNER",
    "INSERT": "INSERT",
    "INSTEAD": "INSTEAD",
    "INTERSECT": "INTERSECT",
    "INTO": "INTO",
    "IS": "IS",
    "ISNULL": "ISNULL",
    "JOIN": "JOIN",
    "KEY": "KEY",
    "LEFT": "LEFT",
    "LIKE": "LIKE",
    "LIMIT": "LIMIT",
    "MATCH": "MATCH",
    "NATURAL": "NATURAL",
    "NO": "NO",
    "NOT": "NOT",
    "NOTNULL": "NOTNULL",
    "NULL_": "NULL",
    "OF": "OF",
    "OFFSET": "OFFSET",
    "ON": "ON",
    "OR": "OR",
    "ORDER": "ORDER",
    "OUTER": "OUTER",
    "PLAN": "PLAN",
    "PRAGMA": "PRAGMA",
    "PRIMARY": "PRIMARY",
    "QUERY": "QUERY",
    "RAISE": "RAISE",
    "RECURSIVE": "RECURSIVE",
    "REFERENCES": "REFERENCES",
    "REGEXP": "REGEXP",
    "REINDEX": "REINDEX",
    "RELEASE": "RELEASE",
    "RENAME": "RENAME",
    "REPLACE": "REPLACE",
    "RESTRICT": "RESTRICT",
    "RIGHT": "RIGHT",
    "ROLLBACK": "ROLLBACK",
    "ROW": "ROW",
    "ROWS": "ROWS",
    "SAVEPOINT": "SAVEPOINT",
    "SELECT": "SELECT",
    "SET": "SET",
    "TABLE": "TABLE",
    "TEMP": "TEMP",
    "TEMPORARY": "TEMPORARY",
    "THEN": "THEN",
    "TO": "TO",
    "TRANSACTION": "TRANSACTION",
    "TRIGGER": "TRIGGER",
    "UNION": "UNION",
    "UNIQUE": "UNIQUE",
    "UPDATE": "UPDATE",
    "USING": "USING",
    "VACUUM": "VACUUM",
    "VALUES": "VALUES",
    "VIEW": "VIEW",
    "VIRTUAL": "VIRTUAL",
    "WHEN": "WHEN",
    "WHERE": "WHERE",
    "WITH": "WITH",
    "WITHOUT": "WITHOUT",
    "FIRST_VALUE": "FIRST_VALUE",
    "OVER": "OVER",
    "PARTITION": "PARTITION",
    "RANGE": "RANGE",
    "PRECEDING": "PRECEDING",
    "UNBOUNDED": "UNBOUNDED",
    "CURRENT": "CURRENT",
    "FOLLOWING": "FOLLOWING",
    "CUME_DIST": "CUME_DIST",
    "DENSE_RANK": "DENSE_RANK",
    "LAG": "LAG",
    "LAST_VALUE": "LAST_VALUE",
    "LEAD": "LEAD",
    "NTH_VALUE": "NTH_VALUE",
    "NTILE": "NTILE",
    "PERCENT_RANK": "PERCENT_RANK",
    "RANK": "RANK",
    "ROW_NUMBER": "ROW_NUMBER",
    "GENERATED": "GENERATED",
    "ALWAYS": "ALWAYS",
    "STORED": "STORED",
    "TRUE_": "TRUE",
    "FALSE_": "FALSE",
    "WINDOW": "WINDOW",
    "NULLS": "NULLS",
    "FIRST": "FIRST",
    "LAST": "LAST",
    "FILTER": "FILTER",
    "GROUPS": "GROUPS",
    "EXCLUDE": "EXCLUDE",
    "TIES": "TIES",
    "OTHERS": "OTHERS",
    "DO": "DO",
    "NOTHING": "NOTHING",
}

MYSQL_KEYWORDS = {
    "EQUAL_OPERATOR": "=",
    "ASSIGN_OPERATOR": ":=",
    "NULL_SAFE_EQUAL_OPERATOR": "<=>",
    "GREATER_OR_EQUAL_OPERATOR": ">=",
    "GREATER_THAN_OPERATOR": ">",
    "LESS_OR_EQUAL_OPERATOR": "<=",
    "LESS_THAN_OPERATOR": "<",
    "NOT_EQUAL_OPERATOR": "!=",
    "NOT_EQUAL2_OPERATOR": "<>",
    "PLUS_OPERATOR": "+",
    "MINUS_OPERATOR": "-",
    "MULT_OPERATOR": "*",
    "DIV_OPERATOR": "/",
    "MOD_OPERATOR": "%",
    "LOGICAL_NOT_OPERATOR": "!",
    "BITWISE_NOT_OPERATOR": "~",
    "SHIFT_LEFT_OPERATOR": "<<",
    "SHIFT_RIGHT_OPERATOR": ">>",
    "LOGICAL_AND_OPERATOR": "&&",
    "BITWISE_AND_OPERATOR": "&",
    "BITWISE_XOR_OPERATOR": "^",
    "LOGICAL_OR_OPERATOR": "||",
    "CONCAT_PIPES_SYMBOL": "||",
    "BITWISE_OR_OPERATOR": "|",
    "DOT_SYMBOL": ".",
    "COMMA_SYMBOL": ",",
    "SEMICOLON_SYMBOL": ";",
    "COLON_SYMBOL": ":",
    "OPEN_PAR_SYMBOL": "(",
    "CLOSE_PAR_SYMBOL": ")",
    "OPEN_CURLY_SYMBOL": "{",
    "CLOSE_CURLY_SYMBOL": "}",
    "UNDERLINE_SYMBOL": "_",
    "JSON_SEPARATOR_SYMBOL": "->",
    "JSON_UNQUOTED_SEPARATOR_SYMBOL": "->>",
    "AT_SIGN_SYMBOL": "@",
    "AT_AT_SIGN_SYMBOL": "@@",
    "PARAM_MARKER": "?",
    "ACCESSIBLE_SYMBOL": "ACCESSIBLE",
    "ACCOUNT_SYMBOL": "ACCOUNT",
    "ACTION_SYMBOL": "ACTION",
    "ADD_SYMBOL": "ADD",
    "ADDDATE_SYMBOL": "ADDDATE",
    "AFTER_SYMBOL": "AFTER",
    "AGAINST_SYMBOL": "AGAINST",
    "AGGREGATE_SYMBOL": "AGGREGATE",
    "ALGORITHM_SYMBOL": "ALGORITHM",
    "ALL_SYMBOL": "ALL",
    "ALTER_SYMBOL": "ALTER",
    "ALWAYS_SYMBOL": "ALWAYS",
    "ANALYSE_SYMBOL": "ANALYSE",
    "ANALYZE_SYMBOL": "ANALYZE",
    "AND_SYMBOL": "AND",
    "ANY_SYMBOL": "ANY",
    "AS_SYMBOL": "AS",
    "ASC_SYMBOL": "ASC",
    "ASCII_SYMBOL": "ASCII",
    "ASENSITIVE_SYMBOL": "ASENSITIVE",
    "AT_SYMBOL": "AT",
    "AUTHORS_SYMBOL": "AUTHORS",
    "AUTOEXTEND_SIZE_SYMBOL": "AUTOEXTEND_SIZE",
    "AUTO_INCREMENT_SYMBOL": "AUTO_INCREMENT",
    "AVG_ROW_LENGTH_SYMBOL": "AVG_ROW_LENGTH",
    "AVG_SYMBOL": "AVG",
    "BACKUP_SYMBOL": "BACKUP",
    "BEFORE_SYMBOL": "BEFORE",
    "BEGIN_SYMBOL": "BEGIN",
    "BETWEEN_SYMBOL": "BETWEEN",
    "BIGINT_SYMBOL": "BIGINT",
    "BINARY_SYMBOL": "BINARY",
    "BINLOG_SYMBOL": "BINLOG",
    "BIN_NUM_SYMBOL": "BIN_NUM",
    "BIT_AND_SYMBOL": "BIT_AND",
    "BIT_OR_SYMBOL": "BIT_OR",
    "BIT_SYMBOL": "BIT",
    "BIT_XOR_SYMBOL": "BIT_XOR",
    "BLOB_SYMBOL": "BLOB",
    "BLOCK_SYMBOL": "BLOCK",
    "BOOLEAN_SYMBOL": "BOOLEAN",
    "BOOL_SYMBOL": "BOOL",
    "BOTH_SYMBOL": "BOTH",
    "BTREE_SYMBOL": "BTREE",
    "BY_SYMBOL": "BY",
    "BYTE_SYMBOL": "BYTE",
    "CACHE_SYMBOL": "CACHE",
    "CALL_SYMBOL": "CALL",
    "CASCADE_SYMBOL": "CASCADE",
    "CASCADED_SYMBOL": "CASCADED",
    "CASE_SYMBOL": "CASE",
    "CAST_SYMBOL": "CAST",
    "CATALOG_NAME_SYMBOL": "CATALOG_NAME",
    "CHAIN_SYMBOL": "CHAIN",
    "CHANGE_SYMBOL": "CHANGE",
    "CHANGED_SYMBOL": "CHANGED",
    "CHANNEL_SYMBOL": "CHANNEL",
    "CHARSET_SYMBOL": "CHARSET",
    "CHARACTER_SYMBOL": "CHARACTER",
    "CHAR_SYMBOL": "CHAR",
    "CHECKSUM_SYMBOL": "CHECKSUM",
    "CHECK_SYMBOL": "CHECK",
    "CIPHER_SYMBOL": "CIPHER",
    "CLASS_ORIGIN_SYMBOL": "CLASS_ORIGIN",
    "CLIENT_SYMBOL": "CLIENT",
    "CLOSE_SYMBOL": "CLOSE",
    "COALESCE_SYMBOL": "COALESCE",
    "CODE_SYMBOL": "CODE",
    "COLLATE_SYMBOL": "COLLATE",
    "COLLATION_SYMBOL": "COLLATION",
    "COLUMNS_SYMBOL": "COLUMNS",
    "COLUMN_SYMBOL": "COLUMN",
    "COLUMN_NAME_SYMBOL": "COLUMN_NAME",
    "COLUMN_FORMAT_SYMBOL": "COLUMN_FORMAT",
    "COMMENT_SYMBOL": "COMMENT",
    "COMMITTED_SYMBOL": "COMMITTED",
    "COMMIT_SYMBOL": "COMMIT",
    "COMPACT_SYMBOL": "COMPACT",
    "COMPLETION_SYMBOL": "COMPLETION",
    "COMPRESSED_SYMBOL": "COMPRESSED",
    "COMPRESSION_SYMBOL": "COMPRESSION",
    "CONCURRENT_SYMBOL": "CONCURRENT",
    "CONDITION_SYMBOL": "CONDITION",
    "CONNECTION_SYMBOL": "CONNECTION",
    "CONSISTENT_SYMBOL": "CONSISTENT",
    "CONSTRAINT_SYMBOL": "CONSTRAINT",
    "CONSTRAINT_CATALOG_SYMBOL": "CONSTRAINT_CATALOG",
    "CONSTRAINT_NAME_SYMBOL": "CONSTRAINT_NAME",
    "CONSTRAINT_SCHEMA_SYMBOL": "CONSTRAINT_SCHEMA",
    "CONTAINS_SYMBOL": "CONTAINS",
    "CONTEXT_SYMBOL": "CONTEXT",
    "CONTINUE_SYMBOL": "CONTINUE",
    "CONTRIBUTORS_SYMBOL": "CONTRIBUTORS",
    "CONVERT_SYMBOL": "CONVERT",
    "COUNT_SYMBOL": "COUNT",
    "CPU_SYMBOL": "CPU",
    "CREATE_SYMBOL": "CREATE",
    "CROSS_SYMBOL": "CROSS",
    "CUBE_SYMBOL": "CUBE",
    "CURDATE_SYMBOL": "CURDATE",
    "CURRENT_SYMBOL": "CURRENT",
    "CURRENT_DATE_SYMBOL": "CURRENT_DATE",
    "CURRENT_TIME_SYMBOL": "CURRENT_TIME",
    "CURRENT_TIMESTAMP_SYMBOL": "CURRENT_TIMESTAMP",
    "CURRENT_USER_SYMBOL": "CURRENT_USER",
    "CURSOR_SYMBOL": "CURSOR",
    "CURSOR_NAME_SYMBOL": "CURSOR_NAME",
    "CURTIME_SYMBOL": "CURTIME",
    "DATABASE_SYMBOL": "DATABASE",
    "DATABASES_SYMBOL": "DATABASES",
    "DATAFILE_SYMBOL": "DATAFILE",
    "DATA_SYMBOL": "DATA",
    "DATETIME_SYMBOL": "DATETIME",
    "DATE_ADD_SYMBOL": "DATE_ADD",
    "DATE_SUB_SYMBOL": "DATE_SUB",
    "DATE_SYMBOL": "DATE",
    "DAYOFMONTH_SYMBOL": "DAYOFMONTH",
    "DAY_HOUR_SYMBOL": "DAY_HOUR",
    "DAY_MICROSECOND_SYMBOL": "DAY_MICROSECOND",
    "DAY_MINUTE_SYMBOL": "DAY_MINUTE",
    "DAY_SECOND_SYMBOL": "DAY_SECOND",
    "DAY_SYMBOL": "DAY",
    "DEALLOCATE_SYMBOL": "DEALLOCATE",
    "DEC_SYMBOL": "DEC",
    "DECIMAL_NUM_SYMBOL": "DECIMAL_NUM",
    "DECIMAL_SYMBOL": "DECIMAL",
    "DECLARE_SYMBOL": "DECLARE",
    "DEFAULT_SYMBOL": "DEFAULT",
    "DEFAULT_AUTH_SYMBOL": "DEFAULT_AUTH",
    "DEFINER_SYMBOL": "DEFINER",
    "DELAYED_SYMBOL": "DELAYED",
    "DELAY_KEY_WRITE_SYMBOL": "DELAY_KEY_WRITE",
    "DELETE_SYMBOL": "DELETE",
    "DESC_SYMBOL": "DESC",
    "DESCRIBE_SYMBOL": "DESCRIBE",
    "DES_KEY_FILE_SYMBOL": "DES_KEY_FILE",
    "DETERMINISTIC_SYMBOL": "DETERMINISTIC",
    "DIAGNOSTICS_SYMBOL": "DIAGNOSTICS",
    "DIRECTORY_SYMBOL": "DIRECTORY",
    "DISABLE_SYMBOL": "DISABLE",
    "DISCARD_SYMBOL": "DISCARD",
    "DISK_SYMBOL": "DISK",
    "DISTINCT_SYMBOL": "DISTINCT",
    "DISTINCTROW_SYMBOL": "DISTINCTROW",
    "DIV_SYMBOL": "DIV",
    "DOUBLE_SYMBOL": "DOUBLE",
    "DO_SYMBOL": "DO",
    "DROP_SYMBOL": "DROP",
    "DUAL_SYMBOL": "DUAL",
    "DUMPFILE_SYMBOL": "DUMPFILE",
    "DUPLICATE_SYMBOL": "DUPLICATE",
    "DYNAMIC_SYMBOL": "DYNAMIC",
    "EACH_SYMBOL": "EACH",
    "ELSE_SYMBOL": "ELSE",
    "ELSEIF_SYMBOL": "ELSEIF",
    "ENABLE_SYMBOL": "ENABLE",
    "ENCLOSED_SYMBOL": "ENCLOSED",
    "ENCRYPTION_SYMBOL": "ENCRYPTION",
    "END_SYMBOL": "END",
    "ENDS_SYMBOL": "ENDS",
    "END_OF_INPUT_SYMBOL": "END_OF_INPUT",
    "ENGINES_SYMBOL": "ENGINES",
    "ENGINE_SYMBOL": "ENGINE",
    "ENUM_SYMBOL": "ENUM",
    "ERROR_SYMBOL": "ERROR",
    "ERRORS_SYMBOL": "ERRORS",
    "ESCAPED_SYMBOL": "ESCAPED",
    "ESCAPE_SYMBOL": "ESCAPE",
    "EVENTS_SYMBOL": "EVENTS",
    "EVENT_SYMBOL": "EVENT",
    "EVERY_SYMBOL": "EVERY",
    "EXCHANGE_SYMBOL": "EXCHANGE",
    "EXECUTE_SYMBOL": "EXECUTE",
    "EXISTS_SYMBOL": "EXISTS",
    "EXIT_SYMBOL": "EXIT",
    "EXPANSION_SYMBOL": "EXPANSION",
    "EXPIRE_SYMBOL": "EXPIRE",
    "EXPLAIN_SYMBOL": "EXPLAIN",
    "EXPORT_SYMBOL": "EXPORT",
    "EXTENDED_SYMBOL": "EXTENDED",
    "EXTENT_SIZE_SYMBOL": "EXTENT_SIZE",
    "EXTRACT_SYMBOL": "EXTRACT",
    "FALSE_SYMBOL": "FALSE",
    "FAST_SYMBOL": "FAST",
    "FAULTS_SYMBOL": "FAULTS",
    "FETCH_SYMBOL": "FETCH",
    "FIELDS_SYMBOL": "FIELDS",
    "FILE_SYMBOL": "FILE",
    "FILE_BLOCK_SIZE_SYMBOL": "FILE_BLOCK_SIZE",
    "FILTER_SYMBOL": "FILTER",
    "FIRST_SYMBOL": "FIRST",
    "FIXED_SYMBOL": "FIXED",
    "FLOAT4_SYMBOL": "FLOAT4",
    "FLOAT8_SYMBOL": "FLOAT8",
    "FLOAT_SYMBOL": "FLOAT",
    "FLUSH_SYMBOL": "FLUSH",
    "FOLLOWS_SYMBOL": "FOLLOWS",
    "FORCE_SYMBOL": "FORCE",
    "FOREIGN_SYMBOL": "FOREIGN",
    "FOR_SYMBOL": "FOR",
    "FORMAT_SYMBOL": "FORMAT",
    "FOUND_SYMBOL": "FOUND",
    "FROM_SYMBOL": "FROM",
    "FULL_SYMBOL": "FULL",
    "FULLTEXT_SYMBOL": "FULLTEXT",
    "FUNCTION_SYMBOL": "FUNCTION",
    "GET_SYMBOL": "GET",
    "GENERAL_SYMBOL": "GENERAL",
    "GENERATED_SYMBOL": "GENERATED",
    "GROUP_REPLICATION_SYMBOL": "GROUP_REPLICATION",
    "GEOMETRYCOLLECTION_SYMBOL": "GEOMETRYCOLLECTION",
    "GEOMETRY_SYMBOL": "GEOMETRY",
    "GET_FORMAT_SYMBOL": "GET_FORMAT",
    "GLOBAL_SYMBOL": "GLOBAL",
    "GRANT_SYMBOL": "GRANT",
    "GRANTS_SYMBOL": "GRANTS",
    "GROUP_SYMBOL": "GROUP",
    "GROUP_CONCAT_SYMBOL": "GROUP_CONCAT",
    "HANDLER_SYMBOL": "HANDLER",
    "HASH_SYMBOL": "HASH",
    "HAVING_SYMBOL": "HAVING",
    "HELP_SYMBOL": "HELP",
    "HIGH_PRIORITY_SYMBOL": "HIGH_PRIORITY",
    "HOST_SYMBOL": "HOST",
    "HOSTS_SYMBOL": "HOSTS",
    "HOUR_MICROSECOND_SYMBOL": "HOUR_MICROSECOND",
    "HOUR_MINUTE_SYMBOL": "HOUR_MINUTE",
    "HOUR_SECOND_SYMBOL": "HOUR_SECOND",
    "HOUR_SYMBOL": "HOUR",
    "IDENTIFIED_SYMBOL": "IDENTIFIED",
    "IF_SYMBOL": "IF",
    "IGNORE_SYMBOL": "IGNORE",
    "IGNORE_SERVER_IDS_SYMBOL": "IGNORE_SERVER_IDS",
    "IMPORT_SYMBOL": "IMPORT",
    "INDEXES_SYMBOL": "INDEXES",
    "INDEX_SYMBOL": "INDEX",
    "INFILE_SYMBOL": "INFILE",
    "INITIAL_SIZE_SYMBOL": "INITIAL_SIZE",
    "INNER_SYMBOL": "INNER",
    "INOUT_SYMBOL": "INOUT",
    "INSENSITIVE_SYMBOL": "INSENSITIVE",
    "INSERT_SYMBOL": "INSERT",
    "INSERT_METHOD_SYMBOL": "INSERT_METHOD",
    "INSTANCE_SYMBOL": "INSTANCE",
    "INSTALL_SYMBOL": "INSTALL",
    "INTEGER_SYMBOL": "INTEGER",
    "INTERVAL_SYMBOL": "INTERVAL",
    "INTO_SYMBOL": "INTO",
    "INT_SYMBOL": "INT",
    "INVOKER_SYMBOL": "INVOKER",
    "IN_SYMBOL": "IN",
    "IO_AFTER_GTIDS_SYMBOL": "IO_AFTER_GTIDS",
    "IO_BEFORE_GTIDS_SYMBOL": "IO_BEFORE_GTIDS",
    "IO_THREAD_SYMBOL": "IO_THREAD",
    "IO_SYMBOL": "IO",
    "IPC_SYMBOL": "IPC",
    "IS_SYMBOL": "IS",
    "ISOLATION_SYMBOL": "ISOLATION",
    "ISSUER_SYMBOL": "ISSUER",
    "ITERATE_SYMBOL": "ITERATE",
    "JOIN_SYMBOL": "JOIN",
    "JSON_SYMBOL": "JSON",
    "KEYS_SYMBOL": "KEYS",
    "KEY_BLOCK_SIZE_SYMBOL": "KEY_BLOCK_SIZE",
    "KEY_SYMBOL": "KEY",
    "KILL_SYMBOL": "KILL",
    "LANGUAGE_SYMBOL": "LANGUAGE",
    "LAST_SYMBOL": "LAST",
    "LEADING_SYMBOL": "LEADING",
    "LEAVES_SYMBOL": "LEAVES",
    "LEAVE_SYMBOL": "LEAVE",
    "LEFT_SYMBOL": "LEFT",
    "LESS_SYMBOL": "LESS",
    "LEVEL_SYMBOL": "LEVEL",
    "LIKE_SYMBOL": "LIKE",
    "LIMIT_SYMBOL": "LIMIT",
    "LINEAR_SYMBOL": "LINEAR",
    "LINES_SYMBOL": "LINES",
    "LINESTRING_SYMBOL": "LINESTRING",
    "LIST_SYMBOL": "LIST",
    "LOAD_SYMBOL": "LOAD",
    "LOCALTIME_SYMBOL": "LOCALTIME",
    "LOCALTIMESTAMP_SYMBOL": "LOCALTIMESTAMP",
    "LOCAL_SYMBOL": "LOCAL",
    "LOCATOR_SYMBOL": "LOCATOR",
    "LOCKS_SYMBOL": "LOCKS",
    "LOCK_SYMBOL": "LOCK",
    "LOGFILE_SYMBOL": "LOGFILE",
    "LOGS_SYMBOL": "LOGS",
    "LONGBLOB_SYMBOL": "LONGBLOB",
    "LONGTEXT_SYMBOL": "LONGTEXT",
    "LONG_NUM_SYMBOL": "LONG_NUM",
    "LONG_SYMBOL": "LONG",
    "LOOP_SYMBOL": "LOOP",
    "LOW_PRIORITY_SYMBOL": "LOW_PRIORITY",
    "MASTER_AUTO_POSITION_SYMBOL": "MASTER_AUTO_POSITION",
    "MASTER_BIND_SYMBOL": "MASTER_BIND",
    "MASTER_CONNECT_RETRY_SYMBOL": "MASTER_CONNECT_RETRY",
    "MASTER_DELAY_SYMBOL": "MASTER_DELAY",
    "MASTER_HOST_SYMBOL": "MASTER_HOST",
    "MASTER_LOG_FILE_SYMBOL": "MASTER_LOG_FILE",
    "MASTER_LOG_POS_SYMBOL": "MASTER_LOG_POS",
    "MASTER_PASSWORD_SYMBOL": "MASTER_PASSWORD",
    "MASTER_PORT_SYMBOL": "MASTER_PORT",
    "MASTER_RETRY_COUNT_SYMBOL": "MASTER_RETRY_COUNT",
    "MASTER_SERVER_ID_SYMBOL": "MASTER_SERVER_ID",
    "MASTER_SSL_CAPATH_SYMBOL": "MASTER_SSL_CAPATH",
    "MASTER_SSL_CA_SYMBOL": "MASTER_SSL_CA",
    "MASTER_SSL_CERT_SYMBOL": "MASTER_SSL_CERT",
    "MASTER_SSL_CIPHER_SYMBOL": "MASTER_SSL_CIPHER",
    "MASTER_SSL_CRL_SYMBOL": "MASTER_SSL_CRL",
    "MASTER_SSL_CRLPATH_SYMBOL": "MASTER_SSL_CRLPATH",
    "MASTER_SSL_KEY_SYMBOL": "MASTER_SSL_KEY",
    "MASTER_SSL_SYMBOL": "MASTER_SSL",
    "MASTER_SSL_VERIFY_SERVER_CERT_SYMBOL": "MASTER_SSL_VERIFY_SERVER_CERT",
    "MASTER_SYMBOL": "MASTER",
    "MASTER_TLS_VERSION_SYMBOL": "MASTER_TLS_VERSION",
    "MASTER_USER_SYMBOL": "MASTER_USER",
    "MASTER_HEARTBEAT_PERIOD_SYMBOL": "MASTER_HEARTBEAT_PERIOD",
    "MATCH_SYMBOL": "MATCH",
    "MAX_CONNECTIONS_PER_HOUR_SYMBOL": "MAX_CONNECTIONS_PER_HOUR",
    "MAX_QUERIES_PER_HOUR_SYMBOL": "MAX_QUERIES_PER_HOUR",
    "MAX_ROWS_SYMBOL": "MAX_ROWS",
    "MAX_SIZE_SYMBOL": "MAX_SIZE",
    "MAX_STATEMENT_TIME_SYMBOL": "MAX_STATEMENT_TIME",
    "MAX_SYMBOL": "MAX",
    "MAX_UPDATES_PER_HOUR_SYMBOL": "MAX_UPDATES_PER_HOUR",
    "MAX_USER_CONNECTIONS_SYMBOL": "MAX_USER_CONNECTIONS",
    "MAXVALUE_SYMBOL": "MAXVALUE",
    "MEDIUMBLOB_SYMBOL": "MEDIUMBLOB",
    "MEDIUMINT_SYMBOL": "MEDIUMINT",
    "MEDIUMTEXT_SYMBOL": "MEDIUMTEXT",
    "MEDIUM_SYMBOL": "MEDIUM",
    "MEMORY_SYMBOL": "MEMORY",
    "MERGE_SYMBOL": "MERGE",
    "MESSAGE_TEXT_SYMBOL": "MESSAGE_TEXT",
    "MICROSECOND_SYMBOL": "MICROSECOND",
    "MID_SYMBOL": "MID",
    "MIDDLEINT_SYMBOL": "MIDDLEINT",
    "MIGRATE_SYMBOL": "MIGRATE",
    "MINUTE_MICROSECOND_SYMBOL": "MINUTE_MICROSECOND",
    "MINUTE_SECOND_SYMBOL": "MINUTE_SECOND",
    "MINUTE_SYMBOL": "MINUTE",
    "MIN_ROWS_SYMBOL": "MIN_ROWS",
    "MIN_SYMBOL": "MIN",
    "MODE_SYMBOL": "MODE",
    "MODIFIES_SYMBOL": "MODIFIES",
    "MODIFY_SYMBOL": "MODIFY",
    "MOD_SYMBOL": "MOD",
    "MONTH_SYMBOL": "MONTH",
    "MULTILINESTRING_SYMBOL": "MULTILINESTRING",
    "MULTIPOINT_SYMBOL": "MULTIPOINT",
    "MULTIPOLYGON_SYMBOL": "MULTIPOLYGON",
    "MUTEX_SYMBOL": "MUTEX",
    "MYSQL_ERRNO_SYMBOL": "MYSQL_ERRNO",
    "NAMES_SYMBOL": "NAMES",
    "NAME_SYMBOL": "NAME",
    "NATIONAL_SYMBOL": "NATIONAL",
    "NATURAL_SYMBOL": "NATURAL",
    "NCHAR_STRING_SYMBOL": "NCHAR_STRING",
    "NCHAR_SYMBOL": "NCHAR",
    "NDB_SYMBOL": "NDB",
    "NDBCLUSTER_SYMBOL": "NDBCLUSTER",
    "NEG_SYMBOL": "NEG",
    "NEVER_SYMBOL": "NEVER",
    "NEW_SYMBOL": "NEW",
    "NEXT_SYMBOL": "NEXT",
    "NODEGROUP_SYMBOL": "NODEGROUP",
    "NONE_SYMBOL": "NONE",
    "NONBLOCKING_SYMBOL": "NONBLOCKING",
    "NOT_SYMBOL": "NOT",
    "NOT2_SYMBOL": "NOT_SYMBOL",
    "NOW_SYMBOL": "NOW",
    "NO_SYMBOL": "NO",
    "NO_WAIT_SYMBOL": "NO_WAIT",
    "NO_WRITE_TO_BINLOG_SYMBOL": "NO_WRITE_TO_BINLOG",
    "NULL_SYMBOL": "NULL",
    "NUMBER_SYMBOL": "NUMBER",
    "NUMERIC_SYMBOL": "NUMERIC",
    "NVARCHAR_SYMBOL": "NVARCHAR",
    "OFFLINE_SYMBOL": "OFFLINE",
    "OFFSET_SYMBOL": "OFFSET",
    "OLD_PASSWORD_SYMBOL": "OLD_PASSWORD",
    "ON_SYMBOL": "ON",
    "ONE_SYMBOL": "ONE",
    "ONLINE_SYMBOL": "ONLINE",
    "ONLY_SYMBOL": "ONLY",
    "OPEN_SYMBOL": "OPEN",
    "OPTIMIZE_SYMBOL": "OPTIMIZE",
    "OPTIMIZER_COSTS_SYMBOL": "OPTIMIZER_COSTS",
    "OPTIONS_SYMBOL": "OPTIONS",
    "OPTION_SYMBOL": "OPTION",
    "OPTIONALLY_SYMBOL": "OPTIONALLY",
    "ORDER_SYMBOL": "ORDER",
    "OR_SYMBOL": "OR",
    "OUTER_SYMBOL": "OUTER",
    "OUTFILE_SYMBOL": "OUTFILE",
    "OUT_SYMBOL": "OUT",
    "OWNER_SYMBOL": "OWNER",
    "PACK_KEYS_SYMBOL": "PACK_KEYS",
    "PAGE_SYMBOL": "PAGE",
    "PARSER_SYMBOL": "PARSER",
    "PARTIAL_SYMBOL": "PARTIAL",
    "PARTITIONING_SYMBOL": "PARTITIONING",
    "PARTITIONS_SYMBOL": "PARTITIONS",
    "PARTITION_SYMBOL": "PARTITION",
    "PASSWORD_SYMBOL": "PASSWORD",
    "PHASE_SYMBOL": "PHASE",
    "PLUGINS_SYMBOL": "PLUGINS",
    "PLUGIN_DIR_SYMBOL": "PLUGIN_DIR",
    "PLUGIN_SYMBOL": "PLUGIN",
    "POINT_SYMBOL": "POINT",
    "POLYGON_SYMBOL": "POLYGON",
    "PORT_SYMBOL": "PORT",
    "POSITION_SYMBOL": "POSITION",
    "PRECEDES_SYMBOL": "PRECEDES",
    "PRECISION_SYMBOL": "PRECISION",
    "PREPARE_SYMBOL": "PREPARE",
    "PRESERVE_SYMBOL": "PRESERVE",
    "PREV_SYMBOL": "PREV",
    "PRIMARY_SYMBOL": "PRIMARY",
    "PRIVILEGES_SYMBOL": "PRIVILEGES",
    "PROCEDURE_SYMBOL": "PROCEDURE",
    "PROCESS_SYMBOL": "PROCESS",
    "PROCESSLIST_SYMBOL": "PROCESSLIST",
    "PROFILE_SYMBOL": "PROFILE",
    "PROFILES_SYMBOL": "PROFILES",
    "PROXY_SYMBOL": "PROXY",
    "PURGE_SYMBOL": "PURGE",
    "QUARTER_SYMBOL": "QUARTER",
    "QUERY_SYMBOL": "QUERY",
    "QUICK_SYMBOL": "QUICK",
    "RANGE_SYMBOL": "RANGE",
    "READS_SYMBOL": "READS",
    "READ_ONLY_SYMBOL": "READ_ONLY",
    "READ_SYMBOL": "READ",
    "READ_WRITE_SYMBOL": "READ_WRITE",
    "REAL_SYMBOL": "REAL",
    "REBUILD_SYMBOL": "REBUILD",
    "RECOVER_SYMBOL": "RECOVER",
    "REDOFILE_SYMBOL": "REDOFILE",
    "REDO_BUFFER_SIZE_SYMBOL": "REDO_BUFFER_SIZE",
    "REDUNDANT_SYMBOL": "REDUNDANT",
    "REFERENCES_SYMBOL": "REFERENCES",
    "REGEXP_SYMBOL": "REGEXP",
    "RELAY_SYMBOL": "RELAY",
    "RELAYLOG_SYMBOL": "RELAYLOG",
    "RELAY_LOG_FILE_SYMBOL": "RELAY_LOG_FILE",
    "RELAY_LOG_POS_SYMBOL": "RELAY_LOG_POS",
    "RELAY_THREAD_SYMBOL": "RELAY_THREAD",
    "RELEASE_SYMBOL": "RELEASE",
    "RELOAD_SYMBOL": "RELOAD",
    "REMOVE_SYMBOL": "REMOVE",
    "RENAME_SYMBOL": "RENAME",
    "REORGANIZE_SYMBOL": "REORGANIZE",
    "REPAIR_SYMBOL": "REPAIR",
    "REPEATABLE_SYMBOL": "REPEATABLE",
    "REPEAT_SYMBOL": "REPEAT",
    "REPLACE_SYMBOL": "REPLACE",
    "REPLICATION_SYMBOL": "REPLICATION",
    "REPLICATE_DO_DB_SYMBOL": "REPLICATE_DO_DB",
    "REPLICATE_IGNORE_DB_SYMBOL": "REPLICATE_IGNORE_DB",
    "REPLICATE_DO_TABLE_SYMBOL": "REPLICATE_DO_TABLE",
    "REPLICATE_IGNORE_TABLE_SYMBOL": "REPLICATE_IGNORE_TABLE",
    "REPLICATE_WILD_DO_TABLE_SYMBOL": "REPLICATE_WILD_DO_TABLE",
    "REPLICATE_WILD_IGNORE_TABLE_SYMBOL": "REPLICATE_WILD_IGNORE_TABLE",
    "REPLICATE_REWRITE_DB_SYMBOL": "REPLICATE_REWRITE_DB",
    "REQUIRE_SYMBOL": "REQUIRE",
    "RESET_SYMBOL": "RESET",
    "RESIGNAL_SYMBOL": "RESIGNAL",
    "RESTORE_SYMBOL": "RESTORE",
    "RESTRICT_SYMBOL": "RESTRICT",
    "RESUME_SYMBOL": "RESUME",
    "RETURNED_SQLSTATE_SYMBOL": "RETURNED_SQLSTATE",
    "RETURNS_SYMBOL": "RETURNS",
    "RETURN_SYMBOL": "RETURN",
    "REVERSE_SYMBOL": "REVERSE",
    "REVOKE_SYMBOL": "REVOKE",
    "RIGHT_SYMBOL": "RIGHT",
    "RLIKE_SYMBOL": "RLIKE",
    "ROLLBACK_SYMBOL": "ROLLBACK",
    "ROLLUP_SYMBOL": "ROLLUP",
    "ROTATE_SYMBOL": "ROTATE",
    "ROUTINE_SYMBOL": "ROUTINE",
    "ROWS_SYMBOL": "ROWS",
    "ROW_COUNT_SYMBOL": "ROW_COUNT",
    "ROW_FORMAT_SYMBOL": "ROW_FORMAT",
    "ROW_SYMBOL": "ROW",
    "RTREE_SYMBOL": "RTREE",
    "SAVEPOINT_SYMBOL": "SAVEPOINT",
    "SCHEDULE_SYMBOL": "SCHEDULE",
    "SCHEMA_SYMBOL": "SCHEMA",
    "SCHEMA_NAME_SYMBOL": "SCHEMA_NAME",
    "SCHEMAS_SYMBOL": "SCHEMAS",
    "SECOND_MICROSECOND_SYMBOL": "SECOND_MICROSECOND",
    "SECOND_SYMBOL": "SECOND",
    "SECURITY_SYMBOL": "SECURITY",
    "SELECT_SYMBOL": "SELECT",
    "SENSITIVE_SYMBOL": "SENSITIVE",
    "SEPARATOR_SYMBOL": "SEPARATOR",
    "SERIALIZABLE_SYMBOL": "SERIALIZABLE",
    "SERIAL_SYMBOL": "SERIAL",
    "SESSION_SYMBOL": "SESSION",
    "SERVER_SYMBOL": "SERVER",
    "SERVER_OPTIONS_SYMBOL": "SERVER_OPTIONS",
    "SESSION_USER_SYMBOL": "SESSION_USER",
    "SET_SYMBOL": "SET",
    "SET_VAR_SYMBOL": "SET_VAR",
    "SHARE_SYMBOL": "SHARE",
    "SHOW_SYMBOL": "SHOW",
    "SHUTDOWN_SYMBOL": "SHUTDOWN",
    "SIGNAL_SYMBOL": "SIGNAL",
    "SIGNED_SYMBOL": "SIGNED",
    "SIMPLE_SYMBOL": "SIMPLE",
    "SLAVE_SYMBOL": "SLAVE",
    "SLOW_SYMBOL": "SLOW",
    "SMALLINT_SYMBOL": "SMALLINT",
    "SNAPSHOT_SYMBOL": "SNAPSHOT",
    "SOME_SYMBOL": "SOME",
    "SOCKET_SYMBOL": "SOCKET",
    "SONAME_SYMBOL": "SONAME",
    "SOUNDS_SYMBOL": "SOUNDS",
    "SOURCE_SYMBOL": "SOURCE",
    "SPATIAL_SYMBOL": "SPATIAL",
    "SPECIFIC_SYMBOL": "SPECIFIC",
    "SQLEXCEPTION_SYMBOL": "SQLEXCEPTION",
    "SQLSTATE_SYMBOL": "SQLSTATE",
    "SQLWARNING_SYMBOL": "SQLWARNING",
    "SQL_AFTER_GTIDS_SYMBOL": "SQL_AFTER_GTIDS",
    "SQL_AFTER_MTS_GAPS_SYMBOL": "SQL_AFTER_MTS_GAPS",
    "SQL_BEFORE_GTIDS_SYMBOL": "SQL_BEFORE_GTIDS",
    "SQL_BIG_RESULT_SYMBOL": "SQL_BIG_RESULT",
    "SQL_BUFFER_RESULT_SYMBOL": "SQL_BUFFER_RESULT",
    "SQL_CACHE_SYMBOL": "SQL_CACHE",
    "SQL_CALC_FOUND_ROWS_SYMBOL": "SQL_CALC_FOUND_ROWS",
    "SQL_NO_CACHE_SYMBOL": "SQL_NO_CACHE",
    "SQL_SMALL_RESULT_SYMBOL": "SQL_SMALL_RESULT",
    "SQL_SYMBOL": "SQL",
    "SQL_THREAD_SYMBOL": "SQL_THREAD",
    "SSL_SYMBOL": "SSL",
    "STACKED_SYMBOL": "STACKED",
    "STARTING_SYMBOL": "STARTING",
    "STARTS_SYMBOL": "STARTS",
    "START_SYMBOL": "START",
    "STATS_AUTO_RECALC_SYMBOL": "STATS_AUTO_RECALC",
    "STATS_PERSISTENT_SYMBOL": "STATS_PERSISTENT",
    "STATS_SAMPLE_PAGES_SYMBOL": "STATS_SAMPLE_PAGES",
    "STATUS_SYMBOL": "STATUS",
    "STDDEV_SAMP_SYMBOL": "STDDEV_SAMP",
    "STDDEV_SYMBOL": "STDDEV",
    "STDDEV_POP_SYMBOL": "STDDEV_POP",
    "STD_SYMBOL": "STD",
    "STOP_SYMBOL": "STOP",
    "STORAGE_SYMBOL": "STORAGE",
    "STORED_SYMBOL": "STORED",
    "STRAIGHT_JOIN_SYMBOL": "STRAIGHT_JOIN",
    "STRING_SYMBOL": "STRING",
    "SUBCLASS_ORIGIN_SYMBOL": "SUBCLASS_ORIGIN",
    "SUBDATE_SYMBOL": "SUBDATE",
    "SUBJECT_SYMBOL": "SUBJECT",
    "SUBPARTITIONS_SYMBOL": "SUBPARTITIONS",
    "SUBPARTITION_SYMBOL": "SUBPARTITION",
    "SUBSTR_SYMBOL": "SUBSTR",
    "SUBSTRING_SYMBOL": "SUBSTRING",
    "SUM_SYMBOL": "SUM",
    "SUPER_SYMBOL": "SUPER",
    "SUSPEND_SYMBOL": "SUSPEND",
    "SWAPS_SYMBOL": "SWAPS",
    "SWITCHES_SYMBOL": "SWITCHES",
    "SYSDATE_SYMBOL": "SYSDATE",
    "SYSTEM_USER_SYMBOL": "SYSTEM_USER",
    "TABLES_SYMBOL": "TABLES",
    "TABLESPACE_SYMBOL": "TABLESPACE",
    "TABLE_REF_PRIORITY_SYMBOL": "TABLE_REF_PRIORITY",
    "TABLE_SYMBOL": "TABLE",
    "TABLE_CHECKSUM_SYMBOL": "TABLE_CHECKSUM",
    "TABLE_NAME_SYMBOL": "TABLE_NAME",
    "TEMPORARY_SYMBOL": "TEMPORARY",
    "TEMPTABLE_SYMBOL": "TEMPTABLE",
    "TERMINATED_SYMBOL": "TERMINATED",
    "TEXT_SYMBOL": "TEXT",
    "THAN_SYMBOL": "THAN",
    "THEN_SYMBOL": "THEN",
    "TIMESTAMP_SYMBOL": "TIMESTAMP",
    "TIMESTAMP_ADD_SYMBOL": "TIMESTAMP_ADD",
    "TIMESTAMP_DIFF_SYMBOL": "TIMESTAMP_DIFF",
    "TIME_SYMBOL": "TIME",
    "TINYBLOB_SYMBOL": "TINYBLOB",
    "TINYINT_SYMBOL": "TINYINT",
    "TINYTEXT_SYMBOL": "TINYTEXT",
    "TO_SYMBOL": "TO",
    "TRAILING_SYMBOL": "TRAILING",
    "TRANSACTION_SYMBOL": "TRANSACTION",
    "TRIGGERS_SYMBOL": "TRIGGERS",
    "TRIGGER_SYMBOL": "TRIGGER",
    "TRIM_SYMBOL": "TRIM",
    "TRUE_SYMBOL": "TRUE",
    "TRUNCATE_SYMBOL": "TRUNCATE",
    "TYPES_SYMBOL": "TYPES",
    "TYPE_SYMBOL": "TYPE",
    "UDF_RETURNS_SYMBOL": "UDF_RETURNS",
    "UNCOMMITTED_SYMBOL": "UNCOMMITTED",
    "UNDEFINED_SYMBOL": "UNDEFINED",
    "UNDOFILE_SYMBOL": "UNDOFILE",
    "UNDO_BUFFER_SIZE_SYMBOL": "UNDO_BUFFER_SIZE",
    "UNDO_SYMBOL": "UNDO",
    "UNICODE_SYMBOL": "UNICODE",
    "UNINSTALL_SYMBOL": "UNINSTALL",
    "UNION_SYMBOL": "UNION",
    "UNIQUE_SYMBOL": "UNIQUE",
    "UNKNOWN_SYMBOL": "UNKNOWN",
    "UNLOCK_SYMBOL": "UNLOCK",
    "UNSIGNED_SYMBOL": "UNSIGNED",
    "UNTIL_SYMBOL": "UNTIL",
    "UPDATE_SYMBOL": "UPDATE",
    "UPGRADE_SYMBOL": "UPGRADE",
    "USAGE_SYMBOL": "USAGE",
    "USER_RESOURCES_SYMBOL": "USER_RESOURCES",
    "USER_SYMBOL": "USER",
    "USE_FRM_SYMBOL": "USE_FRM",
    "USE_SYMBOL": "USE",
    "USING_SYMBOL": "USING",
    "UTC_DATE_SYMBOL": "UTC_DATE",
    "UTC_TIMESTAMP_SYMBOL": "UTC_TIMESTAMP",
    "UTC_TIME_SYMBOL": "UTC_TIME",
    "VALIDATION_SYMBOL": "VALIDATION",
    "VALUES_SYMBOL": "VALUES",
    "VALUE_SYMBOL": "VALUE",
    "VARBINARY_SYMBOL": "VARBINARY",
    "VARCHAR_SYMBOL": "VARCHAR",
    "VARCHARACTER_SYMBOL": "VARCHARACTER",
    "VARIABLES_SYMBOL": "VARIABLES",
    "VARIANCE_SYMBOL": "VARIANCE",
    "VARYING_SYMBOL": "VARYING",
    "VAR_POP_SYMBOL": "VAR_POP",
    "VAR_SAMP_SYMBOL": "VAR_SAMP",
    "VIEW_SYMBOL": "VIEW",
    "VIRTUAL_SYMBOL": "VIRTUAL",
    "WAIT_SYMBOL": "WAIT",
    "WARNINGS_SYMBOL": "WARNINGS",
    "WEEK_SYMBOL": "WEEK",
    "WEIGHT_STRING_SYMBOL": "WEIGHT_STRING",
    "WHEN_SYMBOL": "WHEN",
    "WHERE_SYMBOL": "WHERE",
    "WHILE_SYMBOL": "WHILE",
    "WITH_SYMBOL": "WITH",
    "WITHOUT_SYMBOL": "WITHOUT",
    "WORK_SYMBOL": "WORK",
    "WRAPPER_SYMBOL": "WRAPPER",
    "WRITE_SYMBOL": "WRITE",
    "X509_SYMBOL": "X509",
    "XA_SYMBOL": "XA",
    "XID_SYMBOL": "XID",
    "XML_SYMBOL": "XML",
    "XOR_SYMBOL": "XOR",
    "YEAR_MONTH_SYMBOL": "YEAR_MONTH",
    "YEAR_SYMBOL": "YEAR",
    "ZEROFILL_SYMBOL": "ZEROFILL",
    "PERSIST_SYMBOL": "PERSIST",
    "ROLE_SYMBOL": "ROLE",
    "ADMIN_SYMBOL": "ADMIN",
    "INVISIBLE_SYMBOL": "INVISIBLE",
    "VISIBLE_SYMBOL": "VISIBLE",
    "EXCEPT_SYMBOL": "EXCEPT",
    "COMPONENT_SYMBOL": "COMPONENT",
    "RECURSIVE_SYMBOL": "RECURSIVE",
    "JSON_OBJECTAGG_SYMBOL": "JSON_OBJECTAGG",
    "JSON_ARRAYAGG_SYMBOL": "JSON_ARRAYAGG",
    "OF_SYMBOL": "OF",
    "SKIP_SYMBOL": "SKIP",
    "LOCKED_SYMBOL": "LOCKED",
    "NOWAIT_SYMBOL": "NOWAIT",
    "GROUPING_SYMBOL": "GROUPING",
    "PERSIST_ONLY_SYMBOL": "PERSIST_ONLY",
    "HISTOGRAM_SYMBOL": "HISTOGRAM",
    "BUCKETS_SYMBOL": "BUCKETS",
    "REMOTE_SYMBOL": "REMOTE",
    "CLONE_SYMBOL": "CLONE",
    "CUME_DIST_SYMBOL": "CUME_DIST",
    "DENSE_RANK_SYMBOL": "DENSE_RANK",
    "EXCLUDE_SYMBOL": "EXCLUDE",
    "FIRST_VALUE_SYMBOL": "FIRST_VALUE",
    "FOLLOWING_SYMBOL": "FOLLOWING",
    "GROUPS_SYMBOL": "GROUPS",
    "LAG_SYMBOL": "LAG",
    "LAST_VALUE_SYMBOL": "LAST_VALUE",
    "LEAD_SYMBOL": "LEAD",
    "NTH_VALUE_SYMBOL": "NTH_VALUE",
    "NTILE_SYMBOL": "NTILE",
    "NULLS_SYMBOL": "NULLS",
    "OTHERS_SYMBOL": "OTHERS",
    "OVER_SYMBOL": "OVER",
    "PERCENT_RANK_SYMBOL": "PERCENT_RANK",
    "PRECEDING_SYMBOL": "PRECEDING",
    "RANK_SYMBOL": "RANK",
    "RESPECT_SYMBOL": "RESPECT",
    "ROW_NUMBER_SYMBOL": "ROW_NUMBER",
    "TIES_SYMBOL": "TIES",
    "UNBOUNDED_SYMBOL": "UNBOUNDED",
    "WINDOW_SYMBOL": "WINDOW",
    "EMPTY_SYMBOL": "EMPTY",
    "JSON_TABLE_SYMBOL": "JSON_TABLE",
    "NESTED_SYMBOL": "NESTED",
    "ORDINALITY_SYMBOL": "ORDINALITY",
    "PATH_SYMBOL": "PATH",
    "HISTORY_SYMBOL": "HISTORY",
    "REUSE_SYMBOL": "REUSE",
    "SRID_SYMBOL": "SRID",
    "THREAD_PRIORITY_SYMBOL": "THREAD_PRIORITY",
    "RESOURCE_SYMBOL": "RESOURCE",
    "SYSTEM_SYMBOL": "SYSTEM",
    "VCPU_SYMBOL": "VCPU",
    "MASTER_PUBLIC_KEY_PATH_SYMBOL": "MASTER_PUBLIC_KEY_PATH",
    "GET_MASTER_PUBLIC_KEY_SYMBOL": "GET_MASTER_PUBLIC_KEY_SYM",
    "RESTART_SYMBOL": "RESTART",
    "DEFINITION_SYMBOL": "DEFINITION",
    "DESCRIPTION_SYMBOL": "DESCRIPTION",
    "ORGANIZATION_SYMBOL": "ORGANIZATION",
    "REFERENCE_SYMBOL": "REFERENCE",
    "OPTIONAL_SYMBOL": "OPTIONAL",
    "SECONDARY_SYMBOL": "SECONDARY",
    "SECONDARY_ENGINE_SYMBOL": "SECONDARY_ENGINE",
    "SECONDARY_LOAD_SYMBOL": "SECONDARY_LOAD",
    "SECONDARY_UNLOAD_SYMBOL": "SECONDARY_UNLOAD",
    "ACTIVE_SYMBOL": "ACTIVE",
    "INACTIVE_SYMBOL": "INACTIVE",
    "LATERAL_SYMBOL": "LATERAL",
    "RETAIN_SYMBOL": "RETAIN",
    "OLD_SYMBOL": "OLD",
    "NETWORK_NAMESPACE_SYMBOL": "NETWORK_NAMESPACE",
    "ENFORCED_SYMBOL": "ENFORCED",
    "ARRAY_SYMBOL": "ARRAY",
    "OJ_SYMBOL": "OJ",
    "MEMBER_SYMBOL": "MEMBER",
    "RANDOM_SYMBOL": "RANDOM",
    "MASTER_COMPRESSION_ALGORITHM_SYMBOL": "MASTER_COMPRESSION_ALGORITHM",
    "MASTER_ZSTD_COMPRESSION_LEVEL_SYMBOL": "MASTER_ZSTD_COMPRESSION_LEVEL",
    "PRIVILEGE_CHECKS_USER_SYMBOL": "PRIVILEGE_CHECKS_USER",
    "MASTER_TLS_CIPHERSUITES_SYMBOL": "MASTER_TLS_CIPHERSUITES",
    "REQUIRE_ROW_FORMAT_SYMBOL": "REQUIRE_ROW_FORMAT",
    "PASSWORD_LOCK_TIME_SYMBOL": "PASSWORD_LOCK_TIME",
    "FAILED_LOGIN_ATTEMPTS_SYMBOL": "FAILED_LOGIN_ATTEMPTS",
    "REQUIRE_TABLE_PRIMARY_KEY_CHECK_SYMBOL": "REQUIRE_TABLE_PRIMARY_KEY_CHECK",
    "STREAM_SYMBOL": "STREAM",
    "OFF_SYMBOL": "OFF",
    "INT1_SYMBOL": "INT1",
    "INT2_SYMBOL": "INT2",
    "INT3_SYMBOL": "INT3",
    "INT4_SYMBOL": "INT4",
    "INT8_SYMBOL": "INT8",
    "SQL_TSI_SECOND_SYMBOL": "SQL_TSI_SECOND",
    "SQL_TSI_MINUTE_SYMBOL": "SQL_TSI_MINUTE",
    "SQL_TSI_HOUR_SYMBOL": "SQL_TSI_HOUR",
    "SQL_TSI_DAY_SYMBOL": "SQL_TSI_DAY",
    "SQL_TSI_WEEK_SYMBOL": "SQL_TSI_WEEK",
    "SQL_TSI_MONTH_SYMBOL": "SQL_TSI_MONTH",
    "SQL_TSI_QUARTER_SYMBOL": "SQL_TSI_QUARTER",
    "SQL_TSI_YEAR_SYMBOL": "SQL_TSI_YEAR",
    "BACK_TICK": "`",
    "SINGLE_QUOTE": "'",
    "DOUBLE_QUOTE": '"',
}

HANDCRAFTED_SQL_KEYWORDS = {
    "SCOL": ";",
    "COMMA": ",",
    "STAR": "*",
    "WHERE": "WHERE",
    "SELECT": "SELECT",
    "DISTINCT": "DISTINCT",
    "LIMIT": "LIMIT",
    "GROUP": "GROUP",
    "ORDER": "ORDER",
    "BY": "BY",
    "HAVING": "HAVING",
    "AS": "AS",
    "AND": "AND",
    "OR": "OR",
    "DOT": ".",
    "ASC": "ASC",
    "DESC": "DESC",
    "LPAR": "(",
    "RPAR": ")",
    "LIKE": "LIKE",
    "NOT": "NOT",
    "IN": "IN",
    "BETWEEN": "BETWEEN",
    "NULL": "NULL",
    "IS": "IS",
    "PLUS": "+",
    "MINUS": "-",
    "DIV": "/",
    "EQUAL": "=",
    "NEQ": "<>",
    "GTE": ">=",
    "LTE": "<=",
    "GT": ">",
    "LT": "<",
    "UPPER": "UPPER",
    "LOWER": "LOWER",
    "FROM": "FROM",
    "COL_ALIAS": "COL_ALIAS",
    "SUBQ_ALIAS": "COL_ALIAS",
    "TABLE_NAME": "COL_ALIAS",
    "COLUMN_NAME": "COL_ALIAS",
}