import json
import os
import sys
from tqdm import tqdm

# def traverse()

cnt = 0

train_list = []  # list of stories, one story is a dict
valid_list = []
test_list = []


def process(in_file_name):
    global cnt
    cnt += 1
    # print(in_file_name, cnt)

    res = {}
    with open(in_file_name) as in_f:
        a = json.load(in_f)
        res["game_pid"] = a["game_pid"]
        res["game_slug"] = a["game_slug"]
        res["game_url"] = a["game_url"]
        res["details"] = a["details"]
        res["cards"] = []
        res["green_room"] = a["green_room"]
        cardid2card = {}
        for card in a["cards"]:
            b = {"card_id": card["card_id"], "name": card["name"], "namespace": card["namespace"],
                 "description": card["description"], "world_card_id": card["world_card_id"],
                 "stack_size": card["stack_size"], "suggested_strength_card_id": card["suggested_strength_card_id"],
                 "suggested_weakness_card_id": card["suggested_weakness_card_id"]}
            res["cards"].append(b)
            cardid2card[card["card_id"]] = b
        res["characters"] = []
        for cha in a["characters"]:
            b = {"character_seq_id": cha["character_seq_id"], "name": cha["name"], "description": cha["description"],
                 "is_host_character": cha["is_host_character"], "initial_hand_cards": [], "current_hand_cards": []}
            for i_card in cha["initial_hand_cards"]:
                b["initial_hand_cards"].append(cardid2card[i_card["card_id"]])
            for c_card in cha["current_hand_cards"]:
                b["current_hand_cards"].append(cardid2card[c_card["card_id"]])
            res["characters"].append(b)

        res["scenes"] = []
        for scene in a["scenes"]:
            b = {"scene_id": scene["scene_id"], "chapter_number": scene["chapter_number"],
                 "scene_number": scene["scene_number"],
                 "is_final": scene["is_final"], "is_ended": scene["is_ended"],
                 "cast_character_seq_ids": scene["cast_character_seq_ids"],
                 "comments": scene["comments"], "entries": [], "story": ""}

            for entry in scene["entries"]:
                temp = {"seq_id": entry["seq_id"], "character_seq_id": entry["character_seq_id"], "role": entry["role"],
                        "description": entry["description"], "hand_context": entry["hand_context"],
                        "challenge_cards": [], "cards_played_on_challenge": [], "place_card": None,
                        "cards_for_pickup": [], "format": entry["format"], "pretty_format": entry["pretty_format"]}
                try:
                    b["story"] += entry["description"] + '\n'
                except:
                    pass
                if entry["place_card"]:
                    temp["place_card"] = cardid2card[entry["place_card"]["card_id"]]
                try:
                    for c in entry["challenge_cards"]:
                        temp["challenge_cards"].append(cardid2card[c["card_id"]])
                except:
                    # print(in_file_name, scene["scene_id"], entry["seq_id"])
                    pass
                try:
                    for c in entry["cards_played_on_challenge"]:
                        temp["cards_played_on_challenge"].append(cardid2card[c["card_id"]])
                except:
                    # print(in_file_name, scene["scene_id"], entry["seq_id"])
                    pass
                try:
                    for c in entry["cards_for_pickup"]:
                        temp["cards_for_pickup"].append(cardid2card[c["card_id"]])
                except:
                    # print(in_file_name, scene["scene_id"], entry["seq_id"])
                    pass
                b["entries"].append(temp)
            res["scenes"].append(b)

    return res


def read_filenames(file_name):
    res = set()
    with open(file_name) as f:
        lines = f.readlines()
        for line in lines:
            line = line.strip()
            res.add(line.split('/')[-1])
    return res


train_set = read_filenames('train_filenames.txt')
valid_set = read_filenames('validation_filenames.txt')
test_set = read_filenames('test_filenames.txt')
print(train_set & valid_set)
print(train_set & test_set)
print(valid_set & test_set)
print(len(train_set) + len(valid_set) + len(test_set))
print(len(train_set), len(valid_set), len(test_set))
# exit()

train_file = open('train_stories.json', 'w', encoding='utf-8')
valid_file = open('valid_stories.json', 'w', encoding='utf-8')
test_file = open('test_stories.json', 'w', encoding='utf-8')

for root, dirs, files in tqdm(os.walk(os.getcwd())):
    # print(root, dirs, files)
    for file_name in files:
        if not file_name.endswith('.json'):
            continue
        real_file_name = os.path.join(root, file_name)
        if file_name in train_set:
            train_list.append(process(real_file_name))
        elif file_name in valid_set:
            valid_list.append(process(real_file_name))
        elif file_name in test_set:
            test_list.append(process(real_file_name))

json.dump(train_list, train_file, ensure_ascii=False, indent=1)
json.dump(valid_list, valid_file, ensure_ascii=False, indent=1)
json.dump(test_list, test_file, ensure_ascii=False, indent=1)
# print(cnt)
# if os.path.isdir(f):
