import os
import sys
import json
from gen_data import concat


def get_root_dir():
    path = os.path.abspath(__file__)
    dir_name = 'Persona-Guided-Story-Generation'
    x = path.find(dir_name) + len(dir_name)
    path = path[:x]

    return path


root_dir = get_root_dir()
print(f"root_dir:{root_dir}")
sys.path.append(root_dir)
from evaluation.utils import *


def convert_file(file_name, out_file_name, mode: TextType, ground_truth=False):
    file_name = os.path.join(root_dir, file_name)
    print(f'converting {file_name} ...')
    res = []
    with open(file_name, encoding='utf-8') as f:
        a = json.load(f)
        for scene in a:
            persona = process_text(scene['cards'], TextType.cards)
            if ground_truth:
                output = process_text(scene['answer'], mode)
            else:
                output = process_text(scene['generated'], mode)
            res.append({'text': concat(persona, output), "label": None})

    with open(out_file_name, 'w', encoding='utf-8') as f:
        json.dump({'data': res}, f, ensure_ascii=False, indent=1)


if __name__ == '__main__':
    
    # ground truth
    # convert_file('result/final/kg_combine4_reweight_outline_onecard_version17_1.0.json', 'ground_truth.json', mode=TextType.plan_tbe, ground_truth=True)
    
    # baseline
    # convert_file('result/final/plan_write_out.json', 'plan_write.json', mode=TextType.bte)
    # convert_file('result/final/plan_ahead_bte_onecard_1.0.json', 'plan_ahead.json', mode=TextType.bte)
    # convert_file('result/final/fusion.json', 'fusion.json', mode=TextType.bte)
    convert_file('result/final/fusion_0518.json', 'fusion_0518.json', mode=TextType.bte)
    # convert_file('result/final/gpt2_baseline_bte_onecard_1.0_ori.json', 'gpt2.json', mode=TextType.bte) # gpt2
    # convert_file('result/final/gpt2_baseline_bte_nopretrain_version3_1.0_persona.json', 'seq2seq.json', mode=TextType.bte) # seq2seq
    # convert_file('result/final/gpt2_baseline_tbe_onecard_1.0.json', 'tbe.json', mode=TextType.tbe) # tbe
    # ours
    # convert_file('result/final/gpt2_bte_outline_knowledge_onecard_version3_1.0.json', 'wo_target_planning.json', mode=TextType.bte_outline)
    # convert_file('result/final/kg_combine4_reweight_outline_onecard_version17_1.0.json', 'reweight.json', mode=TextType.plan_tbe)
    # convert_file('result/final/kg_combine4_outline_onecard_version5_1.0.json', 'wo_reweight.json', mode=TextType.plan_tbe)
    # convert_file('result/final/gpt2_wo_knowledge_onecard_version3_1.0.json', 'wo_knowledge.json', mode=TextType.plan_tbe)
    # convert_file('result/final/baseline_dynamic_outline_version_num0_sent1.json', 'outline_baseline.json', mode=TextType.plan_tbe) # 这个ablation换成wo_knowledge


                 
