#!/usr/bin/env bash
set -e 
set -x 


GPU='0'
SEED=('42')

for s in "${SEED[@]}"
do
CKPT_NAME='bert_ace_'${s}
CKPT_NUM=('5')

for zone in "${CKPT_NUM[@]}"
do
python test_bert_crf.py \
     --ckpt_name=${CKPT_NAME}-pred \
     --load_ckpt=checkpoints/${CKPT_NAME}/epoch_${zone}.ckpt \
     --gpus ${GPU} \
     --data_file=preprocessed/preprocessed_${CKPT_NAME} \
     --role_num=25\
     --dataset="ACE"\
     --seed ${s}
done 

done