## Datasets

We provide the **raw files** and **preprocessed files** for TimeQuestions and TempQuestions.

The files are organized as follow:

- **TimeQuestions**
  - **raw**: ./datasets/TimeQuestions/raw
  - **preprocessed**: ./datasets/TimeQuestions/preprocessed
- **TempQuestions**
  - **raw**: ./datasets/TempQuestions/raw
  - **preprocessed**: ./datasets/TempQuestions/preprocessed

### Format of preprocessed files

The questions are annotated in JSON format. The linked entities are in **entity_linking** fields. The temporal elements and temporal relations are in **labels** and **temporal_relations** fields respectively. The meaning of **label** tags for the temporal elements are listed as follows:

- E1: nominal event
- E2: predicative event epxressed with verbs
- E3: predicative event expressed with nouns
- T1: time expressions
- T2: temporal interrogatives
- S1: temporal signal for relations
- S2: ordinal signals
  
## Logs for Experimental results

We provide **logs** for the results that correspond to **the tables in the evaluation section**.

The **logs** for **main results** are as follows:

- **TimeQuestions**: ./predicted_results/TimeQuestions/tq_test_overall.log
- **TempQuestions**: ./predicted_results/TempQuestions/teq_test_overall.log

The **logs** for **table 5**  are as follows:

- **TimeQuestions**

  - **Full System**: ./predicted_results/TimeQuestions/tq_test_RC_overall.log
  - **w/o IS-4 to 6**: ./predicted_results/TimeQuestions/tq_test_RC_wo_is4to6.log
  - **w/o IS-1 to 6**: ./predicted_results/TimeQuestions/tq_test_RC_wo_is1to6.log
- **TempQuestions**
  - **Full System**: ./predicted_results/TempQuestions/teq_test_RC_overall.log
  - **w/o IS-4 to 6**: ./predicted_results/TempQuestions/teq_test_RC_wo_is4to6.log
  - **w/o IS-1 to 6**: ./predicted_results/TempQuestions/teq_test_RC_wo_is1to6.log

The **logs** for **table 7** are as follows:

- **TimeQuestions**
  - **Full System**: ./predicted_results/TimeQuestions/tq_test_overall.log
  - **w/o confusing**: ./predicted_results/TimeQuestions/tq_test_wo_confusing.log
  - **w/o irrelevant**: ./predicted_results/TimeQuestions/tq_test_wo_irrelevant.log
  - **random neg.**: ./predicted_results/TimeQuestions/tq_test_random_neg.log
- **TempQuestions**
  - **Full System**: ./predicted_results/TempQuestions/teq_test_overall.log
  - **w/o confusing**: ./predicted_results/TempQuestions/teq_test_wo_confusing.log
  - **w/o irrelevant**: ./predicted_results/TempQuestions/teq_test_wo_irrelevant.log
  - **random neg.**: ./predicted_results/TempQuestions/teq_test_random_neg.log



