import logging
from nio import AsyncClient, MatrixRoom, RoomMessageText

from autorecorderbot.chat_functions import react_to_event, send_text_to_room
from autorecorderbot.config import Config
from autorecorderbot.storage import Storage


class Command:
    def __init__(
        self,
        client: AsyncClient,
        store: Storage,
        config: Config,
        command: str,
        room: MatrixRoom,
        event: RoomMessageText,
    ):
        """A command made by a user.

        Args:
            client: The client to communicate to matrix with.

            store: Bot storage.

            config: Bot configuration parameters.

            command: The command and arguments.

            room: The room the command was sent in.

            event: The event describing the command.
        """
        self.client = client
        self.store = store
        self.config = config
        self.command = command
        self.room = room
        self.event = event
        self.args = self.command.split()[1:]

    async def process(self):
        pass

    async def _no(self):
        response = "Okay, I will leave now."
        await send_text_to_room(self.client, self.room.room_id, response)
        await self.client.room_leave(self.room.room_id)
        self.store.delete_room(self.room.room_id)
    
    async def _yes(self):
        response = "I will stay and record your messages. This bot will record all messages sent in this room. The main purpose is to automatically detect the type of a message " + \
            "(problem, solution, cause) and store it to the teamboard." 
        await send_text_to_room(self.client, self.room.room_id, response)
        self.store.set_room_recording(self.room.room_id)

    async def _unknown_command(self):
        if not self.store.get_room_recording(self.room.room_id):
            response = "I did not quite understand what you said, so I assume I should not record."
            await send_text_to_room(self.client, self.room.room_id, response)
            await self.client.room_leave(self.room.room_id)
            self.store.delete_room(self.room.room_id)
