# -*- coding: utf-8 -*-
"""
Created on Fri Jun 12 13:11:41 2020

@author: asengup6
"""

import os
import shutil
import logging
from flask import Flask, render_template, request, send_from_directory, url_for
from flask_uploads import UploadSet, configure_uploads, IMAGES, TEXT
from werkzeug import secure_filename #for cluster use from werkzeug.utils import secure_filename
#import predict
import pandas as pd
import json
import generate

PROJECT_HOME = os.path.dirname(os.path.realpath(__file__))
UPLOAD_FOLDER = '{}/uploads/'.format(PROJECT_HOME)
STATIC_FOLDER = '{}/static/'.format(PROJECT_HOME)
UPLOAD_FOLDER = UPLOAD_FOLDER.replace('\\','/')
STATIC_FOLDER = STATIC_FOLDER.replace('\\','/')

# Flask constructor takes the name of
# current module (__name__) as argument.
app = Flask(__name__)

file_handler = logging.FileHandler('server.log')
app.logger.addHandler(file_handler)
app.logger.setLevel(logging.INFO)

app.config['UPLOAD_FOLDER'] = UPLOAD_FOLDER
app.config['STATIC_FOLDER'] = STATIC_FOLDER

def create_new_folder(local_dir):
    newpath = local_dir
    if not os.path.exists(newpath):
        os.makedirs(newpath)
    return newpath
    
all_classes = ['allergies', 'billing', 'demographics', 'documents', 'family', 'history', \
               'images', 'medications', 'others', 'problems', 'results', 'test', 'vaccines', 'vitals']
               
result_df = pd.DataFrame(columns=['barcode','page']+all_classes)

# The route() function of the Flask class is a decorator,
# which tells the application which URL should call
# the associated function.

@app.route('/')
# ‘/’ URL is bound with hello_world() function.
def main_dash():
    message = 'Give image and text to get prediction'
    pred = ''
    text = ''
    return render_template('index.html', message = message, pred = pred, text = text)


@app.route('/result', methods=['GET','POST'])
def read_image():    
    global saved_path_image, saved_path_txt, saved_path_hocr
    
    app.logger.info(PROJECT_HOME)
    
    if request.method == 'POST' and request.files['image_filename'] and request.files['text_filename'] and request.files['hocr_filename']:
        app.logger.info(app.config['UPLOAD_FOLDER'])
        img = request.files['image_filename']
        img_name = secure_filename(img.filename)
        create_new_folder(app.config['UPLOAD_FOLDER'])
        saved_path_image = os.path.join(app.config['UPLOAD_FOLDER'], img_name)
        app.logger.info("saving {}".format(saved_path_image))
        img.save(saved_path_image)
       
        txt = request.files['text_filename']
        txt_name = secure_filename(txt.filename)
        saved_path_txt = os.path.join(app.config['UPLOAD_FOLDER'], txt_name)
        app.logger.info("saving {}".format(saved_path_txt))
        txt.save(saved_path_txt)
        
        hocr = request.files['hocr_filename']
        hocr_name = secure_filename(hocr.filename)
        saved_path_hocr = os.path.join(app.config['UPLOAD_FOLDER'], hocr_name)
        app.logger.info("saving {}".format(saved_path_hocr))
        hocr.save(saved_path_hocr)
        
        saved_path_image = saved_path_image.replace('\\','/')
        saved_path_txt = saved_path_txt.replace('\\','/')
        saved_path_hocr = saved_path_hocr.replace('\\','/')
    
        return process() #send_from_directory(app.config['UPLOAD_FOLDER'],img_name, as_attachment=True), send_from_directory(app.config['UPLOAD_FOLDER'],txt_name, as_attachment=True)
        
    else:
        return render_template('result.html', message="Where are the inputs", pred="", text = "") #"Where are the files"
        
        
def process():
    global result_df
    
    prediction, df, output_ = predict.inference(saved_path_image,saved_path_txt,saved_path_hocr)
    
    result_df = pd.concat([result_df,df],axis=0)
    result_df = result_df[['barcode','page']+all_classes]
    
    result_df.to_csv(os.path.join(app.config['STATIC_FOLDER'],'all_results.csv'),index=False,float_format='%.3f')

    #print('The given text is: ', prediction)
    message = 'The extracted text is: '
    
    with open(os.path.join(app.config['STATIC_FOLDER'],saved_path_image.split('/')[-1].replace('.png','.json')),'w') as f:
        json.dump(output_, f, indent=4)

    os.remove(saved_path_image)
    os.remove(saved_path_txt)
    os.remove(saved_path_hocr)
    
    return render_template('result.html', message=message, pred=str(prediction), text = json.dumps(output_, indent=4), image_file=saved_path_image.split('/')[-1])

@app.route('/report')
def results_tables():
    all_results = pd.read_csv(os.path.join(app.config['STATIC_FOLDER'],'all_results.csv'), index_col=False)
    return render_template('tables.html', all_results = all_results)
    
@app.route('/download_image', methods=['GET','POST'])
def download_image():
    return send_from_directory(app.config['STATIC_FOLDER'], saved_path_image.split('/')[-1], as_attachment=True)
    
@app.route('/download_text', methods=['GET','POST'])
def download_text():
    return send_from_directory(app.config['STATIC_FOLDER'], saved_path_image.split('/')[-1].replace('.png','.json'), as_attachment=True)
    
@app.route('/download_table', methods=['GET','POST'])
def download_table():
    return send_from_directory(app.config['STATIC_FOLDER'], 'all_results.csv', as_attachment=True)

@app.route('/refresh', methods=['GET','POST'])
def refresh():
    os.remove(os.path.join(app.config['STATIC_FOLDER'],saved_path_image.split('/')[-1].replace('.png','.json')))
    os.remove(os.path.join(app.config['STATIC_FOLDER'],saved_path_image.split('/')[-1]))
    
    message = 'Give image and text to get prediction'
    pred = ''
    text = ''
    return render_template('index.html', message = message, pred = pred, text = text)
    
# main driver function
if __name__ == '__main__':
    # run() method of Flask class runs the application
    # on the local development server.
    app.run()