# -*- coding:utf-8 -*-

class Trie:
    def __init__(self):
        self.root = {}
        self.end = -1
    def insert(self, word):
        curNode = self.root
        for c in word:
            if not c in curNode:
                curNode[c] = {}
            curNode = curNode[c]
        curNode[self.end] = True
    def search(self, word):
        curNode = self.root
        for c in word:
            if not c in curNode:
                return False
            curNode = curNode[c]
        # Doesn't end here
        if not self.end in curNode:
            return False
        return True
    def startsWith(self, prefix):
        curNode = self.root
        for c in prefix:
            if not c in curNode:
                return False
            curNode = curNode[c]
        return True

def init_cidian(cidian_file):
    obj=Trie()
    with open(cidian_file, "r",encoding='utf-8')as f1:
        #tries = Trie()
        lines = f1.readlines()
        for line in lines:
            line = line.strip()
            obj.insert(line)
        return obj
