# Contextualizing Hate Speech Classifiers

## How to run

(Note: Data is not published at this moment)

Model training
```
CUDA_VISIBLE_DEVICES=0 python run_model.py \
    --do_train \
    --do_eval \
    --do_lower_case \
    --data_dir ./data/majority_gab_dataset_25k/ \
    --bert_model bert-base-uncased \
    --max_seq_length 128 \
    --train_batch_size 32 \
    --learning_rate 2e-5 \
    --num_train_epochs 3 \
    --output_dir runs/<model_dir>  \
    --seed 0
```

## Running Explanations
### Running word level explanations
- Sampling and Occlusion (SOC): https://arxiv.org/abs/1911.06194
- GradSHAP (GradSHAP): https://arxiv.org/abs/1705.07874
```
CUDA_VISIBLE_DEVICES=0 python run_model.py \
    --task gab \
    --do_eval \
    --do_lower_case \
    --data_dir ./data/majority_gab_dataset_25k/ \
    --bert_model bert-base-uncased \
    --max_seq_length 128 \
    --eval_batch_size 1 \
    --output_dir runs/<model_dir> \
    --seed 0 \
    --algo <soc|gradshap> \
    --nb_range <nb_range> \
    --sample_n <sample_n> \
    --output_filename <filename> \
    --explain
```

You will expect an output file at `runs/<model_dir>/<filename>.txt`, one line for each
instance in dev set. (currently only output explanations for examples with label 1).
Positive score notes for evidence for offensive language. For example:
```
fucking 3.517853	 foreigner 0.585364	 . 0.082448	 i -0.068469	 don -0.094718	 ' -0.090242	 t -0.139986
```
Entries `<word>[space]<score>` are separated with `TAB`.

### Running hierarchical explanations
- Sampling and Occlusion (SOC) to generate phrase level importance scores
- Agglomerative clustering algorithm in ACD to output a hierarchical layout. Just add the option `--hiex`
  in the command line.
  
You will expect an output file at `runs/<model_dir>/<filename>.pkl`, a pickled python list,
where each item is a python dictionary ` {
            'tab': data,
            'text': text,
            'label': label_name,
            'pred': gt_prediction_score
        }`. `data` is a numpy array storing scores to be shown in the hierarchy.
The pickled file can be visualized with `visualize.py`.

See `scripts` folder for scripts for running experiments.