-- This module will transliterate Nogai language text per WT:NOG TR.

local export = {}

local tt = {
	["а"]="a", ["б"]="b", ["в"]="v", ["г"]="g", ["д"]="d", ["е"]="e", ["ё"]="yo", ["ж"]="j",
	["з"]="z", ["и"]="i", ["й"]="y", ["к"]="k", ["л"]="l", ["м"]="m", ["н"]="n", ["о"]="o", 
	["п"]="p", ["р"]="r", ["с"]="s", ["т"]="t", ["у"]="u", ["ф"]="f", ["х"]="x", ["ц"]="c", 
	["ч"]="ç", ["ш"]="ş", ["щ"]="şç", ["ъ"]="”", ["ы"]="ı", ["ь"]="’", ["э"]="é", ["ю"]="yu",
	["я"]="ya", ["А"]="A", ["Б"]="B", ["В"]="V", ["Г"]="G", ["Д"]="D", ["Е"]="E", ["Ё"]="Yo", ["Ж"]="J",
	["З"]="Z", ["И"]="I", ["Й"]="Y", ["К"]="K", ["Л"]="L", ["М"]="M", ["Н"]="N", ["О"]="O", 
	["П"]="P", ["Р"]="R", ["С"]="S", ["Т"]="T", ["У"]="U", ["Ф"]="F", ["Х"]="X", ["Ц"]="C", 
	["Ч"]="Ç", ["Ш"]="Ş", ["Щ"]="Şç", ["Ъ"]="”", ["Ы"]="I", ["Ь"]="’", ["Э"]="É", ["Ю"]="Yu",
	["Я"]="Ya"};

local digraphs = {
	['аь'] = 'ä',
	['Аь'] = 'Ä',
	['нъ'] = 'ñ',
	['Нъ'] = 'Ñ',
	['оь'] = 'ö',
	['Оь'] = 'Ö',
	['уь'] = 'ü',
	['Уь'] = 'Ü',
}

function export.tr(text)
	text = mw.ustring.gsub(
		text,
		"([АОУЫЕЯЁЮИЕаоуыэяёюиеь%A][́̀]?)([Ее])",
		function(a,e)
			return a .. (e == 'е' and 'ye' or 'Ye')
		end
	)
		:gsub("^Е",'Ye')
		:gsub("^е",'ye');
	
	for digraph, translit in pairs(digraphs) do
		text = mw.ustring.gsub(text, digraph, translit)
	end
	
	text = mw.ustring.gsub(text, '.', tt)
	
	return text
end

return export
