#ifndef WEIGHT_FIRST_ORDER_H
#define WEIGHT_FIRST_ORDER_H

#include "macros_base.h"
#include "weight_base.h"
#include "include/perceptron/packed_score.h"

class WeightFirstOrder : public WeightBase {
protected:
    void loadScores(std::istream& is) override;
    void saveScores(std::ostream& os) const override;

public:
    PackedScoreMap< BooleanInt > is_top;
    // 1 阶相邻节点
    PackedScoreMap< TLemmaDirectionInt > lemma_dir_index;
    PackedScoreMap< TNodeDirectionInt > label_dir_index;
    PackedScoreMap< TNodeLemmaDirectionInt > label_lemma_dir_index;
    // 1 阶出边
    PackedScoreMap< TEdgeLemmaInt > edge_lemma_index;
    PackedScoreMap< TEdgeNodeInt > edge_label_index;
    PackedScoreMap< TEdgeNodeLemmaInt > edge_label_lemma_index;
    // 1 阶入边
    PackedScoreMap< TNodeEdgeInt > label_edge_index;
    PackedScoreMap< TLemmaEdgeInt > lemma_edge_index;
    PackedScoreMap< TNodeLemmaEdgeInt > label_lemma_edge_index;

    WeightFirstOrder(const std::string& input_file,
                     const std::string& output_file);

    void computeAverageFeatureWeights(const int& round) override;
};


#endif /* WEIGHT_FIRST_ORDER_H */

// Local Variables:
// mode: c++
// End:
