function ppl =  Calculate_ppl(data, t, net, para)
%
%  ppl =  Calculate_ppl(data, t, net, para)
% 
%  data: batchSize * frameSize.
%  targets: batchSize
%  net:  trained network
%  para: parameters

nLayers = length(para.NNsize);
batchSize = size(data,1);
SHIFT_VECTOR = (0: batchSize-1) * para.NNsize(nLayers);
SHIFT_VECTOR = SHIFT_VECTOR';
%******* Forward
%%Input layer
iLayer = 1;
x = bsxfun(@plus, data * net.w{iLayer}, net.b{iLayer});
y = x.*(x > 0);%%%ReLUs activation function 
%%%%%%%%%%%%%
%%hidden layer
for iLayer = 2 : nLayers-2
  %activation
  x = bsxfun(@plus, y * net.w{iLayer}, net.b{iLayer});
  y = x.*(x > 0);%%%ReLUs activation function 
end
%%%%%%%%%%%output layer
iLayer = nLayers-1;
%%softmax layer
x = exp(bsxfun(@plus, y * net.w{iLayer}, net.b{iLayer}));
y = bsxfun(@rdivide, x, sum(x,2));
%%%%perplexity
ind = t + SHIFT_VECTOR;
y = y';
ppl = sum(log(y(ind)));


