/*
 * Decompiled with CFR 0.152.
 */
package edu.pku.coli.treeapprox;

import edu.pku.coli.io.CCGPARGWriter;
import edu.pku.coli.io.DAGSentenceReader;
import edu.pku.coli.pear.dag.Evaluator;
import edu.pku.coli.pear.dag.PredicateArgumentAdjunctDAG;
import edu.pku.coli.pear.dag.SentenceForDAGParsing;
import edu.pku.coli.treeapprox.DAG2TreeBFS;
import edu.pku.coli.treeapprox.DAG2TreeDFS;
import edu.pku.coli.treeapprox.DAG2TreeDFS_ForwardEdgeFirst;
import edu.pku.coli.treeapprox.DAG2TreeNonProjectiveSimple;
import edu.pku.coli.treeapprox.DAG2TreePhraseStructureTree;
import edu.pku.coli.treeapprox.DAG2TreeProjectiveSimple;
import edu.pku.coli.treeapprox.DAG2TreeTransformer;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStreamWriter;
import java.util.Arrays;
import java.util.List;

public class TransformerSDP2Conll {
    private static DAG2TreeTransformer dag2tree;
    private static String transformer;
    private static String[] transformerArgs;

    static void initialization() {
        boolean changeNullEdge = transformerArgs[0].equalsIgnoreCase("true");
        if (transformer.equalsIgnoreCase("dfs")) {
            dag2tree = new DAG2TreeDFS(changeNullEdge, transformerArgs[1], transformerArgs[2]);
        } else if (transformer.equalsIgnoreCase("iteration")) {
            dag2tree = new DAG2TreeDFS_ForwardEdgeFirst(changeNullEdge, transformerArgs[1], transformerArgs[2]);
        } else if (transformer.equalsIgnoreCase("bfs")) {
            dag2tree = new DAG2TreeBFS(changeNullEdge, transformerArgs[1], transformerArgs[2]);
        } else if (transformer.equalsIgnoreCase("projective")) {
            dag2tree = new DAG2TreeProjectiveSimple(changeNullEdge);
        } else if (transformer.equalsIgnoreCase("nonprojective")) {
            dag2tree = new DAG2TreeNonProjectiveSimple(changeNullEdge);
        }
    }

    public static void main(String[] args) throws Exception {
        String inFilename = args[0];
        String outFilename = args[1];
        transformer = args[2];
        if (transformer.equalsIgnoreCase("pstree")) {
            DAGSentenceReader reader;
            DAG2TreePhraseStructureTree _dag2tree = new DAG2TreePhraseStructureTree();
            File file = new File(outFilename);
            file.createNewFile();
            FileOutputStream fostream = new FileOutputStream(file);
            OutputStreamWriter writer = new OutputStreamWriter(fostream);
            DAGSentenceReader it = reader = DAGSentenceReader.dagsReaderFromSDP(inFilename);
            Evaluator eval = new Evaluator();
            int count = 0;
            for (SentenceForDAGParsing sent : it) {
                if (++count % 1000 == 0) {
                    System.out.print(".");
                }
                try {
                    String newmap = _dag2tree.toTree(sent);
                    char[] s = new char[newmap.length()];
                    newmap.getChars(0, newmap.length(), s, 0);
                    SentenceForDAGParsing newsent = _dag2tree.toDAG(s);
                    eval.registry(sent.getGoldDAG(), newsent.getGoldDAG());
                    writer.write(String.valueOf(newmap) + "\n");
                }
                catch (Exception e) {
                    System.err.println(Arrays.toString(sent.words()));
                    e.printStackTrace();
                    writer.close();
                    System.exit(-1);
                }
            }
            System.out.println(eval);
            writer.close();
        } else {
            DAGSentenceReader reader;
            transformerArgs = !transformer.equalsIgnoreCase("dfs") && !transformer.equalsIgnoreCase("iteration") && !transformer.equalsIgnoreCase("bfs") ? new String[]{"", "", ""} : new String[]{args[3], args[4], args[5]};
            if (transformer.equalsIgnoreCase("nonprojective") || transformer.equalsIgnoreCase("projective")) {
                transformerArgs = new String[]{args[3]};
            }
            TransformerSDP2Conll.initialization();
            CCGPARGWriter writer = new CCGPARGWriter(outFilename);
            DAGSentenceReader it = reader = DAGSentenceReader.dagsReaderFromSDP(inFilename);
            for (SentenceForDAGParsing sent : it) {
                PredicateArgumentAdjunctDAG map = sent.getGoldDAG();
                PredicateArgumentAdjunctDAG newmap = dag2tree.toTree(map);
                List<String> listWords = Arrays.asList(sent.words());
                List<String> listTags = Arrays.asList(sent.tags());
                writer.printOneSentenceCoNLL06(newmap, listWords, listTags);
            }
            writer.close();
        }
    }
}

