/*
 * Decompiled with CFR 0.152.
 */
package babel.ranking;

import babel.content.eqclasses.EquivalenceClass;
import babel.util.dict.Dictionary;
import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EquivClassCandRanking {
    protected static final Log LOG = LogFactory.getLog(EquivClassCandRanking.class);
    protected static final String DEFAULT_ENCODING = "UTF-8";
    protected List<ScoredCandidateSet> m_scoredCandSets;
    protected HashMap<EquivalenceClass, Double> m_cands;
    protected ScoreComparator m_scoreComparator;
    protected EquivalenceClass m_eq;
    protected int m_numBest;
    protected Random m_rand;

    public EquivClassCandRanking(EquivalenceClass eqClass, int numBest, boolean smallerIsBetter) {
        if (eqClass == null) {
            throw new IllegalArgumentException("EquivalenceClass is null.");
        }
        this.m_eq = eqClass;
        this.m_numBest = numBest;
        this.m_scoreComparator = new ScoreComparator(smallerIsBetter);
        this.m_scoredCandSets = numBest < 0 ? new LinkedList() : new ArrayList(numBest + 1);
        this.m_cands = new HashMap();
        this.m_rand = new Random(1L);
    }

    public EquivClassCandRanking clone() {
        EquivClassCandRanking other = new EquivClassCandRanking(this.m_eq, this.m_numBest, this.smallerScoresAreBetter());
        int i = 0;
        while (i < this.m_scoredCandSets.size()) {
            other.m_scoredCandSets.add(this.m_scoredCandSets.get(i).clone());
            ++i;
        }
        for (EquivalenceClass candidate : this.m_cands.keySet()) {
            other.m_cands.put(candidate, this.m_cands.get(candidate));
        }
        return other;
    }

    public boolean smallerScoresAreBetter() {
        return this.m_scoreComparator.m_smallerIsBetter;
    }

    public boolean add(EquivalenceClass candidate, double score) {
        boolean added = false;
        if (this.m_cands.containsKey(candidate)) {
            LOG.warn((Object)("Attempting to add an existing candidate " + candidate.toString() + " to the list for " + this.m_eq.toString() + ", ignoring."));
        } else {
            ScoredCandidateSet candSet = new ScoredCandidateSet(score, candidate);
            int insIdx = Collections.binarySearch(this.m_scoredCandSets, candSet, this.m_scoreComparator);
            boolean newSet = insIdx < 0;
            if (newSet) {
                insIdx = -(insIdx + 1);
            }
            if (this.m_numBest < 0 || this.m_numBest > this.m_cands.size() || insIdx < this.m_scoredCandSets.size()) {
                if (newSet) {
                    this.m_scoredCandSets.add(insIdx, candSet);
                } else {
                    this.m_scoredCandSets.get(insIdx).add(candidate);
                }
                this.m_cands.put(candidate, score);
                added = true;
                if (this.m_cands.size() == this.m_numBest + 1) {
                    candSet = this.m_scoredCandSets.get(this.m_scoredCandSets.size() - 1);
                    EquivalenceClass cand = candSet.randCandidate();
                    candSet.remove(cand);
                    this.m_cands.remove(cand);
                    if (candSet.size() == 0) {
                        this.m_scoredCandSets.remove(candSet);
                    }
                }
            }
        }
        return added;
    }

    public boolean containsCandidate(EquivalenceClass cand) {
        return cand != null && this.m_cands.containsKey(cand);
    }

    public void threshold(double lower, double upper) {
        int idx = this.m_scoredCandSets.size() - 1;
        while (idx >= 0) {
            ScoredCandidateSet candSet = this.m_scoredCandSets.get(idx);
            if (candSet.m_score < lower || candSet.m_score > upper) {
                for (EquivalenceClass eq : candSet.m_candidates) {
                    this.m_cands.remove(eq);
                }
                this.m_scoredCandSets.remove(idx);
            }
            --idx;
        }
    }

    public void clear() {
        this.m_scoredCandSets.clear();
        this.m_cands.clear();
    }

    public EquivalenceClass getEqClass() {
        return this.m_eq;
    }

    public Set<EquivalenceClass> getCandidates() {
        return Collections.unmodifiableSet(this.m_cands.keySet());
    }

    public Map<EquivalenceClass, Double> getScoredCandidates() {
        return Collections.unmodifiableMap(this.m_cands);
    }

    public LinkedHashMap<EquivalenceClass, Double> getOrderedScoredCandidates() {
        LinkedHashMap<EquivalenceClass, Double> map = new LinkedHashMap<EquivalenceClass, Double>();
        for (ScoredCandidateSet candSet : this.m_scoredCandSets) {
            for (EquivalenceClass eq : candSet.m_candidates) {
                map.put(eq, candSet.m_score);
            }
        }
        return map;
    }

    public Double scoreOf(EquivalenceClass candidate) {
        return this.m_cands.get(candidate);
    }

    public double rankOf(EquivalenceClass candidate) {
        double rank = -1.0;
        if (this.m_cands.containsKey(candidate)) {
            rank = 0.0;
            double curSize = 0.0;
            int i = 0;
            while (i < this.m_scoredCandSets.size()) {
                curSize = this.m_scoredCandSets.get(i).size();
                if (!this.m_scoredCandSets.get(i).contains(candidate)) {
                    rank += curSize;
                } else {
                    rank += (curSize + 1.0) / 2.0;
                    break;
                }
                ++i;
            }
        }
        return rank;
    }

    public int numInTopK(Collection<EquivalenceClass> cands, int k) {
        int num = 0;
        for (EquivalenceClass eq : cands) {
            double d;
            double rank = this.rankOf(eq);
            if (!(d > 0.0) || !(rank <= (double)k)) continue;
            ++num;
        }
        return num;
    }

    public EquivalenceClass getBestCandidate() {
        return this.m_scoredCandSets.size() == 0 ? null : this.m_scoredCandSets.get(0).randCandidate();
    }

    public EquivalenceClass getRandomCandidate() {
        return this.m_scoredCandSets.size() == 0 ? null : this.m_scoredCandSets.get(this.m_rand.nextInt(this.m_scoredCandSets.size())).randCandidate();
    }

    public Double getBestScore() {
        return this.m_scoredCandSets.size() == 0 ? null : this.m_scoredCandSets.get(0).score();
    }

    public int numCandidates() {
        return this.m_cands.size();
    }

    public String toString() {
        StringBuffer strBuf = new StringBuffer();
        strBuf.append("<");
        strBuf.append(this.m_eq.toString());
        strBuf.append(">\n");
        for (ScoredCandidateSet curSet : this.m_scoredCandSets) {
            strBuf.append("   ");
            strBuf.append(curSet);
            strBuf.append("\n");
        }
        return strBuf.toString();
    }

    protected void flagTranslations(Collection<EquivalenceClass> translations) {
        for (ScoredCandidateSet set : this.m_scoredCandSets) {
            set.flagIfContainsAnyCandidates(translations);
        }
    }

    public static void dumpToFile(Dictionary dict, Collection<EquivClassCandRanking> candRankings, String fileName) throws Exception {
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(fileName), DEFAULT_ENCODING));
        for (EquivClassCandRanking candRanking : candRankings) {
            Set<EquivalenceClass> translations = dict.translate(candRanking.m_eq);
            if (translations != null) {
                candRanking.flagTranslations(translations);
            }
            writer.write(candRanking.toString());
            writer.newLine();
        }
        writer.close();
    }

    protected class ScoreComparator
    implements Comparator<ScoredCandidateSet> {
        protected boolean m_smallerIsBetter;

        public ScoreComparator(boolean smallerIsBetter) {
            this.m_smallerIsBetter = smallerIsBetter;
        }

        public boolean smallerScoresAreBetter() {
            return this.m_smallerIsBetter;
        }

        @Override
        public int compare(ScoredCandidateSet setOne, ScoredCandidateSet setTwo) {
            int score = 0;
            if (setOne.m_score > setTwo.m_score) {
                score = this.m_smallerIsBetter ? 1 : -1;
            } else if (setOne.m_score < setTwo.m_score) {
                score = this.m_smallerIsBetter ? -1 : 1;
            }
            return score;
        }
    }

    public class ScoredCandidateSet {
        protected LinkedHashSet<EquivalenceClass> m_candidates = new LinkedHashSet();
        protected double m_score;
        protected boolean m_flag;

        private ScoredCandidateSet(double score) {
            this.m_score = score;
            this.m_flag = false;
        }

        public ScoredCandidateSet(double score, EquivalenceClass candidate) {
            this(score);
            this.add(candidate);
        }

        public ScoredCandidateSet clone() {
            ScoredCandidateSet set = new ScoredCandidateSet(this.m_score);
            set.m_flag = this.m_flag;
            for (EquivalenceClass candidate : this.m_candidates) {
                set.add(candidate);
            }
            return set;
        }

        public boolean add(EquivalenceClass candidate) {
            if (candidate == null) {
                throw new IllegalArgumentException("No candidate EquivalenceClass specified.");
            }
            return this.m_candidates.add(candidate);
        }

        boolean remove(EquivalenceClass candidate) {
            return this.m_candidates.remove(candidate);
        }

        public void flagIfContainsAnyCandidates(Collection<EquivalenceClass> cands) {
            this.m_flag = false;
            for (EquivalenceClass cand : cands) {
                if (!this.m_candidates.contains(cand)) continue;
                this.m_flag = true;
                break;
            }
        }

        public boolean contains(EquivalenceClass cand) {
            return this.m_candidates.contains(cand);
        }

        public Double score() {
            return this.m_score;
        }

        public Set<EquivalenceClass> candidates() {
            return Collections.unmodifiableSet(this.m_candidates);
        }

        public EquivalenceClass randCandidate() {
            int idx = EquivClassCandRanking.this.m_rand.nextInt(this.m_candidates.size());
            Iterator iter = this.m_candidates.iterator();
            EquivalenceClass eq = null;
            int i = 0;
            while (i <= idx) {
                eq = (EquivalenceClass)iter.next();
                ++i;
            }
            return eq;
        }

        public int size() {
            return this.m_candidates.size();
        }

        public String toString() {
            StringBuilder strBld = new StringBuilder(String.valueOf(this.m_flag ? "* " : "") + "[" + this.m_score + "]");
            for (EquivalenceClass eq : this.m_candidates) {
                strBld.append(" ");
                strBld.append(eq.toString());
            }
            return strBld.toString();
        }
    }
}

