/*
 * Decompiled with CFR 0.152.
 */
package babel.content.eqclasses.properties.number;

import babel.content.corpora.accessors.CorpusAccessor;
import babel.content.eqclasses.EquivalenceClass;
import babel.content.eqclasses.phrases.Phrase;
import babel.content.eqclasses.properties.PhrasePropertyCollector;
import babel.content.eqclasses.properties.number.Number;
import babel.util.misc.GettableHashSet;
import java.io.BufferedReader;
import java.util.List;
import java.util.Set;

public class PhraseNumberCollector
extends PhrasePropertyCollector {
    public PhraseNumberCollector(int maxPhraseLength, boolean caseSensitive) {
        super(maxPhraseLength, caseSensitive);
    }

    @Override
    public void collectProperty(CorpusAccessor corpusAccess, Set<? extends EquivalenceClass> phrases) throws Exception {
        String curLine;
        BufferedReader reader = new BufferedReader(corpusAccess.getCorpusReader());
        GettableHashSet<? extends EquivalenceClass> phMap = new GettableHashSet<EquivalenceClass>(phrases);
        while ((curLine = reader.readLine()) != null) {
            curLine = curLine.trim();
            List<String> curSents = PhraseNumberCollector.getSentences(curLine, corpusAccess.isOneSentencePerLine());
            for (String sent : curSents) {
                List<PhrasePropertyCollector.IdxPair> sentPhraseIdxs = PhraseNumberCollector.getAllPhraseIdxs(sent, this.m_maxPhraseLength);
                for (PhrasePropertyCollector.IdxPair phraseIdx : sentPhraseIdxs) {
                    Phrase tmpPhrase = new Phrase();
                    tmpPhrase.init(sent.substring(phraseIdx.from, phraseIdx.to), this.m_caseSensitive);
                    Phrase foundPhrase = (Phrase)phMap.get(tmpPhrase);
                    if (foundPhrase == null) continue;
                    Number foundNumber = (Number)foundPhrase.getProperty(Number.class.getName());
                    if (foundNumber == null) {
                        foundNumber = new Number();
                        foundPhrase.setProperty(foundNumber);
                    }
                    foundNumber.increment();
                }
            }
        }
        reader.close();
    }
}

