/*
 * Decompiled with CFR 0.152.
 */
package babel.content.eqclasses.properties;

import babel.content.eqclasses.phrases.Phrase;
import babel.content.eqclasses.properties.PropertyCollector;
import babel.util.misc.InvertibleHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class PhrasePropertyCollector
extends PropertyCollector {
    protected static final Pattern SENT_DELIMS = Pattern.compile("[\\.\\?\u00ac\u00f8!\u00ac\u00b0]+");
    protected static final Pattern PHRASE_DELIMS = Phrase.PHRASE_DELIMS;
    protected static final Pattern WORD_DELIMS = Pattern.compile("[\\|\\$\\*\\s\"'\\-\\+=,;:\u00ac\u00b4\u00ac\u00aa{}()<>\\[\\]\\.\\?\u00ac\u00f8!\u00ac\u00b0\u201a\u00c4\u00ec\u201a\u00c4\u00fa\u201a\u00c4\u00f9\u201a\u00c4\u00f2\u201a\u00c4\u00f4\u00ac\u2020]+");
    protected int m_maxPhraseLength;

    protected PhrasePropertyCollector(int maxPhraseLength, boolean caseSensitive) {
        super(caseSensitive);
        this.m_maxPhraseLength = maxPhraseLength;
    }

    protected static List<String> getSentences(String str, boolean oneSentPerLine) {
        LinkedList<String> sents = new LinkedList<String>();
        if (oneSentPerLine) {
            sents.add(str.substring(0, str.length()));
        } else {
            int sFrom = 0;
            Matcher m = SENT_DELIMS.matcher(str);
            while (m.find()) {
                sents.add(str.substring(sFrom, m.end()));
                sFrom = m.end();
            }
            if (sFrom != str.length()) {
                sents.add(str.substring(sFrom, str.length()));
            }
        }
        return sents;
    }

    protected static InvertibleHashMap<IdxPair, Integer> getAllDelims(String sent, Pattern delimPattern) {
        InvertibleHashMap<IdxPair, Integer> spaces = new InvertibleHashMap<IdxPair, Integer>();
        Matcher m = delimPattern.matcher(sent);
        boolean startsWithDelim = false;
        boolean endsWithDelim = false;
        int idx = 1;
        int sentLength = sent.length();
        if (sent.length() > 0) {
            while (m.find()) {
                if (m.start() == 0) {
                    startsWithDelim = true;
                    idx = 0;
                }
                if (m.end() == sentLength) {
                    endsWithDelim = true;
                }
                spaces.put(new IdxPair(m.start(), m.end()), idx++);
            }
            if (!startsWithDelim) {
                spaces.put(new IdxPair(0, 0), 0);
            }
            if (!endsWithDelim) {
                spaces.put(new IdxPair(sent.length(), sent.length()), idx);
            }
        }
        return spaces;
    }

    protected static List<IdxPair> getAllPhraseIdxs(InvertibleHashMap<IdxPair, Integer> delims, int maxPhraseLength) {
        LinkedList<IdxPair> phrases = new LinkedList<IdxPair>();
        int i = 0;
        while (i < delims.size() - 1) {
            int j = i + 1;
            while ((maxPhraseLength < 0 || maxPhraseLength >= j - i) && j < delims.size()) {
                phrases.add(new IdxPair(delims.getKey((Object)Integer.valueOf((int)i)).to, delims.getKey((Object)Integer.valueOf((int)j)).from));
                ++j;
            }
            ++i;
        }
        return phrases;
    }

    protected static List<IdxPair> getAllWordIdxs(String sent) {
        return PhrasePropertyCollector.getAllPhraseIdxs(PhrasePropertyCollector.getAllDelims(sent, WORD_DELIMS), 1);
    }

    protected static List<IdxPair> getAllPhraseIdxs(String sent, int maxPhraseLength) {
        return PhrasePropertyCollector.getAllPhraseIdxs(PhrasePropertyCollector.getAllDelims(sent, PHRASE_DELIMS), maxPhraseLength);
    }

    public static class IdxPair {
        public final int from;
        public final int to;
        private String strRep = null;

        public IdxPair(int from, int to) {
            this.from = from;
            this.to = to;
        }

        public int hashCode() {
            return this.toString().hashCode();
        }

        public boolean equals(Object obj) {
            return obj instanceof IdxPair && ((IdxPair)obj).from == this.from && ((IdxPair)obj).to == this.to;
        }

        public String toString() {
            return this.strRep == null ? (this.strRep = String.valueOf(this.from) + "->" + this.to) : this.strRep;
        }
    }
}

