/*
 * Decompiled with CFR 0.152.
 */
package babel.content.eqclasses.collectors;

import babel.content.eqclasses.EquivalenceClass;
import babel.content.eqclasses.filters.EquivalenceClassFilter;
import java.io.InputStreamReader;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public abstract class EquivalenceClassCollector {
    protected boolean m_eqCaseSensitive;
    protected Class<? extends EquivalenceClass> m_eqClass;
    protected List<EquivalenceClassFilter> m_filters;

    public EquivalenceClassCollector(String eqClassName, boolean caseSensitive) {
        this(eqClassName, null, caseSensitive);
    }

    public EquivalenceClassCollector(String eqClassName, List<EquivalenceClassFilter> filters, boolean caseSensitive) {
        this.m_eqCaseSensitive = caseSensitive;
        this.m_filters = filters;
        try {
            this.m_eqClass = Class.forName(eqClassName);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.toString());
        }
    }

    public abstract Set<EquivalenceClass> collect(InputStreamReader var1, int var2) throws Exception;

    public static Set<EquivalenceClass> filter(Set<EquivalenceClass> eqs, List<EquivalenceClassFilter> filters) {
        HashSet<EquivalenceClass> newEqs = null;
        if (eqs != null) {
            newEqs = new HashSet<EquivalenceClass>();
            for (EquivalenceClass eq : eqs) {
                if (!EquivalenceClassCollector.keep(eq, filters)) continue;
                newEqs.add(eq);
            }
        }
        return newEqs;
    }

    protected static boolean keep(EquivalenceClass eq, List<EquivalenceClassFilter> filters) {
        boolean keep = true;
        if (filters != null) {
            for (EquivalenceClassFilter filter : filters) {
                keep = filter.acceptEquivalenceClass(eq);
                if (!keep) break;
            }
        }
        return keep;
    }
}

