/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.tokenizer;

import com.aliasi.tokenizer.Tokenizer;

class NGramTokenizer
extends Tokenizer {
    private final char[] mChars;
    private final int mOffset;
    private final int mLength;
    private final int mMaxNGram;
    private int mCurrentSize;
    private int mNextStart;
    private int mLastTokenStartPosition = -1;
    private int mLastTokenEndPosition = -1;

    public NGramTokenizer(char[] ch, int offset, int length, int minNGram, int maxNGram) {
        if (minNGram > maxNGram) {
            String msg = "Require min n-gram to be less than max n-gramfound min=" + minNGram + "found max=" + maxNGram;
            throw new IllegalArgumentException(msg);
        }
        this.mChars = ch;
        this.mOffset = offset;
        this.mLength = length;
        this.mMaxNGram = maxNGram;
        this.mCurrentSize = minNGram;
        this.mNextStart = this.mOffset;
    }

    public int lastTokenStartPosition() {
        return this.mLastTokenStartPosition;
    }

    public int lastTokenEndPosition() {
        return this.mLastTokenEndPosition;
    }

    public String nextToken() {
        while (this.mCurrentSize <= this.mMaxNGram && this.mNextStart + this.mCurrentSize > this.mOffset + this.mLength) {
            ++this.mCurrentSize;
            this.mNextStart = this.mOffset;
        }
        if (this.mCurrentSize > this.mMaxNGram) {
            return null;
        }
        this.mLastTokenStartPosition = this.mNextStart - this.mOffset;
        this.mLastTokenEndPosition = this.mLastTokenStartPosition + this.mCurrentSize;
        return new String(this.mChars, this.mNextStart++, this.mCurrentSize);
    }
}

