/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.matrix;

import com.aliasi.matrix.SparseFloatVector;
import com.aliasi.matrix.Vector;
import com.aliasi.util.Distance;
import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EuclideanDistance
implements Distance<Vector>,
Serializable {
    static final long serialVersionUID = -7331942504500606550L;
    public static final EuclideanDistance DISTANCE = new EuclideanDistance();

    @Override
    public double distance(Vector v1, Vector v2) {
        if (v1.numDimensions() != v2.numDimensions()) {
            String msg = "Vectors must have same dimensions. v1.numDimensions()=" + v1.numDimensions() + " v2.numDimensions()=" + v2.numDimensions();
            throw new IllegalArgumentException(msg);
        }
        if (v1 instanceof SparseFloatVector && v2 instanceof SparseFloatVector) {
            return EuclideanDistance.sparseDistance((SparseFloatVector)v1, (SparseFloatVector)v2);
        }
        double sum = 0.0;
        int i = v1.numDimensions();
        while (--i >= 0) {
            double diff = v1.value(i) - v2.value(i);
            sum += diff * diff;
        }
        return Math.sqrt(sum);
    }

    static double sparseDistance(SparseFloatVector v1, SparseFloatVector v2) {
        double sum = 0.0;
        int index1 = 0;
        int index2 = 0;
        int[] keys1 = v1.mKeys;
        int[] keys2 = v2.mKeys;
        float[] vals1 = v1.mValues;
        float[] vals2 = v2.mValues;
        while (index1 < keys1.length && index2 < keys2.length) {
            int comp = keys1[index1] - keys2[index2];
            double diff = comp == 0 ? (double)(vals1[index1++] - vals2[index2++]) : (double)(comp < 0 ? vals1[index1++] : vals2[index2++]);
            sum += diff * diff;
        }
        while (index1 < keys1.length) {
            sum += (double)(vals1[index1] * vals1[index1]);
            ++index1;
        }
        while (index2 < keys2.length) {
            sum += (double)(vals2[index2] * vals2[index2]);
            ++index2;
        }
        return Math.sqrt(sum);
    }
}

