/*
 * Decompiled with CFR 0.152.
 */
package tsg.metrics;

import java.io.PrintWriter;
import java.util.ArrayList;
import settings.Parameters;
import tsg.Label;
import tsg.TSNodeLabel;

public abstract class ParseMetricOptimizer {
    static double minProb = 1.0E-100;
    public static Label topLabel = Label.getLabel("TOP");
    String[] currentSentenceWords;
    Label[] lexicalItems;
    ArrayList<TSNodeLabel> currentBestTrees = new ArrayList();
    int sentenceLength;
    String identifier;

    public String getIdentifier() {
        return this.identifier;
    }

    public String[] getCurrentSentenceWords() {
        return this.currentSentenceWords;
    }

    public void prepareNextSentence(String[] lexicalItems) {
        this.currentSentenceWords = lexicalItems;
        this.lexicalItems = ParseMetricOptimizer.getLabelArray(lexicalItems);
        this.sentenceLength = lexicalItems.length;
        this.initSentence();
    }

    protected abstract void initSentence();

    public void addNewDerivation(TSNodeLabel tree, double prob) {
        if (prob <= 0.0) {
            prob = minProb;
        }
        this.addNewDerivationChecked(tree, prob);
    }

    protected abstract void addNewDerivationChecked(TSNodeLabel var1, double var2);

    protected abstract TSNodeLabel getBestTree() throws Exception;

    public void storeCurrentBestParseTrees() throws Exception {
        TSNodeLabel bestTree = this.getBestTree();
        if (bestTree == null) {
            Parameters.reportError("Error in storeCurrentBestParseTrees(): bestTree==null");
            return;
        }
        this.currentBestTrees.add(bestTree);
    }

    public void prinBestTrees(PrintWriter pw) throws Exception {
        for (TSNodeLabel t : this.currentBestTrees) {
            pw.println(t.toString());
        }
    }

    public static Label[] getLabelArray(String[] stringArray) {
        int length = stringArray.length;
        Label[] result = new Label[length];
        int i = 0;
        while (i < length) {
            result[i] = Label.getLabel(stringArray[i]);
            ++i;
        }
        return result;
    }
}

