/*
 * Decompiled with CFR 0.152.
 */
package tsg.fragStats;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Scanner;
import java.util.TreeSet;
import org.apache.tools.bzip2.CBZip2InputStream;
import tsg.TSNodeLabel;
import util.ArgumentReader;
import util.FileUtil;
import util.PrintProgress;
import util.Utility;

public class FragmentFileStatistics {
    static boolean read2bytes = true;
    static int absoluteMax = 100;
    static int printProgressEvery = 100000;
    int empiricalMaxDepth;
    int empiricalMaxBranching;
    int empiricalMaxWords;
    int empiricalMaxSubSites;
    int empiricalMaxFronteerNodes;
    File fragmentFile;
    File outputFile;
    long[][] maxDepthTypesTokens;
    long[][] maxBranchingTypesTokens;
    long[][] wordsTypesTokens;
    long[][] subSitesTypesTokens;
    long[][] fronteerNodesTypesTokens;
    Hashtable<Integer, long[]> freqTable;
    PrintProgress progress;

    public FragmentFileStatistics(File fragmentFile, File outputFile, boolean compressed) throws Exception {
        this.fragmentFile = fragmentFile;
        this.outputFile = outputFile;
        this.maxDepthTypesTokens = new long[absoluteMax][2];
        this.maxBranchingTypesTokens = new long[absoluteMax][2];
        this.wordsTypesTokens = new long[absoluteMax][2];
        this.subSitesTypesTokens = new long[absoluteMax][2];
        this.fronteerNodesTypesTokens = new long[absoluteMax][2];
        this.freqTable = new Hashtable();
        this.progress = new PrintProgress("Reading fragments", printProgressEvery, 0);
        if (compressed) {
            this.readFragemntFileCompressed();
        } else {
            this.readFragemntFile();
        }
        this.progress.end();
        this.writeStats();
    }

    private void analyzeNextLine(String line) throws Exception {
        this.progress.next();
        String[] lineSplit = line.split("\t");
        TSNodeLabel fragment = new TSNodeLabel(lineSplit[0], false);
        int freq = Integer.parseInt(lineSplit[1]);
        int maxDepth = fragment.maxDepth();
        int maxBranching = fragment.maxBranching();
        int words = fragment.countLexicalNodes();
        int subSites = fragment.countNonLexicalFronteer();
        int fronteerNodes = fragment.countTerminalNodes();
        if (maxDepth > this.empiricalMaxDepth) {
            this.empiricalMaxDepth = maxDepth;
        }
        if (maxBranching > this.empiricalMaxBranching) {
            this.empiricalMaxBranching = maxBranching;
        }
        if (words > this.empiricalMaxWords) {
            this.empiricalMaxWords = words;
        }
        if (subSites > this.empiricalMaxSubSites) {
            this.empiricalMaxSubSites = subSites;
        }
        if (fronteerNodes > this.empiricalMaxFronteerNodes) {
            this.empiricalMaxFronteerNodes = fronteerNodes;
        }
        if (fronteerNodes < words) {
            System.out.println(line);
            System.out.println("Words: " + words);
            System.out.println("Fronteers Nodes: " + fronteerNodes);
        }
        long[] lArray = this.maxDepthTypesTokens[maxDepth];
        lArray[0] = lArray[0] + 1L;
        long[] lArray2 = this.maxDepthTypesTokens[maxDepth];
        lArray2[1] = lArray2[1] + (long)freq;
        long[] lArray3 = this.maxBranchingTypesTokens[maxBranching];
        lArray3[0] = lArray3[0] + 1L;
        long[] lArray4 = this.maxBranchingTypesTokens[maxBranching];
        lArray4[1] = lArray4[1] + (long)freq;
        long[] lArray5 = this.wordsTypesTokens[words];
        lArray5[0] = lArray5[0] + 1L;
        long[] lArray6 = this.wordsTypesTokens[words];
        lArray6[1] = lArray6[1] + (long)freq;
        long[] lArray7 = this.subSitesTypesTokens[subSites];
        lArray7[0] = lArray7[0] + 1L;
        long[] lArray8 = this.subSitesTypesTokens[subSites];
        lArray8[1] = lArray8[1] + (long)freq;
        long[] lArray9 = this.fronteerNodesTypesTokens[fronteerNodes];
        lArray9[0] = lArray9[0] + 1L;
        long[] lArray10 = this.fronteerNodesTypesTokens[fronteerNodes];
        lArray10[1] = lArray10[1] + (long)freq;
        Utility.increaseInTableLong(this.freqTable, freq);
    }

    private void readFragemntFile() throws Exception {
        Scanner scan = FileUtil.getScanner(this.fragmentFile);
        while (scan.hasNextLine()) {
            String line = scan.nextLine();
            this.analyzeNextLine(line);
        }
        scan.close();
    }

    private void readFragemntFileCompressed() throws Exception {
        String line;
        FileInputStream inputStream = new FileInputStream(this.fragmentFile);
        if (read2bytes) {
            inputStream.read();
            inputStream.read();
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new CBZip2InputStream((InputStream)inputStream), "UTF-8"));
        while ((line = reader.readLine()) != null) {
            this.analyzeNextLine(line);
        }
        reader.close();
    }

    private void writeStats() {
        PrintWriter pw = FileUtil.getPrintWriter(this.outputFile);
        pw.println("Frequency\tTypes");
        TreeSet<Integer> freqSet = new TreeSet<Integer>(this.freqTable.keySet());
        Iterator<Integer> iter = freqSet.descendingIterator();
        while (iter.hasNext()) {
            Integer freq = iter.next();
            long types = this.freqTable.get(freq)[0];
            pw.println(freq + "\t" + types);
        }
        pw.println();
        pw.println("MaxDepth in Fragments\tTypes\tTokens");
        FragmentFileStatistics.printTable(pw, this.maxDepthTypesTokens, this.empiricalMaxDepth);
        pw.println();
        pw.println("MaxBranching in Fragments\tTypes\tTokens");
        FragmentFileStatistics.printTable(pw, this.maxBranchingTypesTokens, this.empiricalMaxBranching);
        pw.println();
        pw.println("Words in Fragments\tTypes\tTokens");
        FragmentFileStatistics.printTable(pw, this.wordsTypesTokens, this.empiricalMaxWords);
        pw.println();
        pw.println("Substitution Sites in Fragments\tTypes\tTokens");
        FragmentFileStatistics.printTable(pw, this.subSitesTypesTokens, this.empiricalMaxSubSites);
        pw.println();
        pw.println("Fronteer Nodes in Fragments\tTypes\tTokens");
        FragmentFileStatistics.printTable(pw, this.fronteerNodesTypesTokens, this.empiricalMaxFronteerNodes);
        absoluteMax = Utility.max(new int[]{this.empiricalMaxDepth, this.empiricalMaxBranching, this.empiricalMaxWords, this.empiricalMaxSubSites, this.empiricalMaxFronteerNodes});
        pw.println();
        pw.println("Summary Fragments Types table\tMaxDepth\tMaxBranching\tWords\tSubstitution Sites\tFronteer Nodes");
        int i = 0;
        while (i <= absoluteMax) {
            pw.print(i);
            FragmentFileStatistics.printTableEntry(pw, this.maxDepthTypesTokens, i, this.empiricalMaxDepth);
            FragmentFileStatistics.printTableEntry(pw, this.maxBranchingTypesTokens, i, this.empiricalMaxBranching);
            FragmentFileStatistics.printTableEntry(pw, this.wordsTypesTokens, i, this.empiricalMaxWords);
            FragmentFileStatistics.printTableEntry(pw, this.subSitesTypesTokens, i, this.empiricalMaxSubSites);
            FragmentFileStatistics.printTableEntry(pw, this.fronteerNodesTypesTokens, i, this.empiricalMaxFronteerNodes);
            pw.println();
            ++i;
        }
        pw.println();
        pw.close();
    }

    private static void printTable(PrintWriter pw, long[][] table, int max) {
        int i = 0;
        while (i <= max) {
            long[] val = table[i];
            pw.println(String.valueOf(i) + "\t" + val[0] + "\t" + val[1]);
            ++i;
        }
    }

    private static void printTableEntry(PrintWriter pw, long[][] table, int i, int max) {
        if (i < max) {
            pw.print("\t" + table[i][0]);
        } else {
            pw.print("\t0");
        }
    }

    public static void main(String[] args) throws Exception {
        File fragmentFile = new File(args[0]);
        File outputFile = new File(args[1]);
        boolean compressed = ArgumentReader.readBooleanOption(args[2]);
        new FragmentFileStatistics(fragmentFile, outputFile, compressed);
    }
}

