/*
 * Decompiled with CFR 0.152.
 */
package tsg.evalHeads;

import java.io.File;
import java.io.IOException;
import java.util.BitSet;
import java.util.Scanner;
import java.util.Vector;
import tsg.TSNode;
import tsg.corpora.ConstCorpusTiger;
import tsg.evalHeads.tigerEval;
import util.FileUtil;

public class TigerDB2HeadsDebug {
    public static int[] readIndexes() {
        File indexFile = new File("sentenceIndexes.txt");
        String line = "";
        try {
            Scanner scan = new Scanner(indexFile);
            while (scan.hasNextLine()) {
                line = String.valueOf(line) + scan.nextLine();
            }
            scan.close();
        }
        catch (IOException e) {
            FileUtil.handleExceptions(e);
        }
        line = line.trim();
        String[] indexeStrings = line.split(", ");
        int[] result = new int[indexeStrings.length];
        int i = 0;
        while (i < indexeStrings.length) {
            result[i] = Integer.parseInt(indexeStrings[i]);
            ++i;
        }
        return result;
    }

    public static void buildIndexBinaryFile(File outputFile) {
        Vector<BitSet> indexesStructure = new Vector<BitSet>();
        ConstCorpusTiger tigerDBGoldCorpus = new ConstCorpusTiger(tigerEval.tigerDBGoldFile, "tigerTBCorpus");
        for (TSNode t : tigerDBGoldCorpus.treeBank) {
            indexesStructure.add(t.getHeadsBitSet());
        }
        FileUtil.toBinaryFile(outputFile, indexesStructure);
    }

    public static void assignHeads(File indexBinaryFIle, File tigerTBCorpusFile, File outputFile) {
        Vector structure = (Vector)FileUtil.fromBinaryFile(indexBinaryFIle);
        ConstCorpusTiger tigerTBCorpus = new ConstCorpusTiger(tigerTBCorpusFile, "tigerTBCorpus");
        int[] indexes = TigerDB2HeadsDebug.readIndexes();
        tigerTBCorpus = tigerTBCorpus.returnIndexes(indexes);
        ConstCorpusTiger tigerDBGoldCorpus = new ConstCorpusTiger(tigerEval.tigerDBGoldFile, "tigerTBCorpus");
        tigerTBCorpus.removeDoubleQuoteTiger();
        int index = 0;
        for (TSNode t : tigerTBCorpus.treeBank) {
            BitSet bs = (BitSet)structure.get(index);
            TSNode original = tigerDBGoldCorpus.treeBank.get(index);
            t.assignHeadFromBitSet(bs);
            ++index;
        }
        tigerTBCorpus.toFile_Complete(outputFile, true);
    }

    public static void run(String[] args) {
        if (args.length != 2) {
            System.err.println("The parameters are not correct.");
            System.err.println("Please use: java -jar TigerDB2Heads.jar <tigerTBCorpusFile> <outputFile>");
            return;
        }
        File sec23File = new File(args[0]);
        if (!sec23File.isFile()) {
            System.err.println("File " + args[0] + " does not exist.");
            return;
        }
        File outputFile = new File(args[1]);
    }

    public static void main(String[] args) {
        File headIndexFile = new File("HeadIndexBinaryFile");
        File outputFile = new File("HeadTigerDB.mrg");
        TigerDB2HeadsDebug.assignHeads(headIndexFile, tigerEval.tigerTBCorpusFile, outputFile);
    }
}

