\NeedsTeXFormat{LaTeX2e}
\ProvidesClass{slides}[Latex class for course slides]

\newcommand{\headlinecolor}{\normalcolor}
\LoadClass{beamer}
\RequirePackage{comment}
\RequirePackage{xcolor}
\RequirePackage{booktabs}
\RequirePackage{etoolbox}
\RequirePackage{tikz}
\RequirePackage{xstring}
\RequirePackage{longtable}
\RequirePackage{ragged2e}
\RequirePackage{geometry}
\RequirePackage{multirow}
\RequirePackage{hyperref}
\RequirePackage{listings}
\RequirePackage{tikz-dependency}
\definecolor{slcolor}{HTML}{882B21}

\usepackage{chronosys}
\usepackage{comment}
\usetheme{metropolis}
\usepackage{multirow}
\usepackage{fp}
\usepackage{xparse}

\setbeamertemplate{caption}{
\insertcaption \\
}

\date{}

\usetikzlibrary{positioning}

\ExplSyntaxOn
\DeclareExpandableDocumentCommand{\eval}{m}{\int_eval:n {#1}}
\ExplSyntaxOff


\definecolor{mygreen}{rgb}{0,0.6,0}
\definecolor{mygray}{rgb}{0.5,0.5,0.5}
\definecolor{mymauve}{rgb}{0.58,0,0.82}

\lstset{ 
  backgroundcolor=\color{white},
  basicstyle=\tiny,
  breakatwhitespace=false,
  breaklines=true,
  captionpos=b,
  commentstyle=\color{mygreen},
  deletekeywords={...},
  escapeinside={\%*}{*)},
  extendedchars=true,
  firstnumber=1,
  frame=single,
  keepspaces=true,
  keywordstyle=\color{blue},
  language=Python,
  morekeywords={True,False},
  numbers=none,
  numbersep=5pt
  numberstyle=\tiny\color{mygray},
  rulecolor=\color{black},
  showspaces=false,
  showstringspaces=false,
  showtabs=false,
  stepnumber=2,
  stringstyle=\color{mymauve},
  tabsize=2,
  title=\lstname
}

%\NewCommandCopy{\olditemize}{\itemize}
\newenvironment{bullets}{\begin{itemize}
\setlength\itemsep{3em}
}{\end{itemize}}

\let\oldblock\block
\addtobeamertemplate{block begin}{
\let\oldtitle\insertblocktitle
\def\insertblocktitle{\oldtitle \vspace{.5cm}}
}

\newenvironment{nblock}[1]{\begin{block}{#1}\vspace{.5cm}}{\end{block}}

\newcommand\instructor[3]{
\begin{minipage}[]{.4\textwidth}
\centering
\includegraphics[height=.25\textheight]{#3}\\
{
\small
#1 \\
#2
}
\end{minipage}
}

\institute{Center for Digital Humanities\\Johns Hopkins University}
