# Copyright (c) Facebook, Inc. and its affiliates. All Rights Reserved.
import errno
import os
from .comm import is_main_process

def mkdir(path):
    try:
        os.makedirs(path)
    except OSError as e:
        if e.errno != errno.EEXIST:
            raise


def save_config(cfg, path):
    if is_main_process():
        with open(path, 'w') as f:
            f.write(cfg.dump())
