import numpy as np
import math
import carla


def rotate_point(point, angle):
    """
    rotate a given point by a given angle
    """
    x_ = math.cos(math.radians(angle)) * point.x - math.sin(math.radians(angle)) * point.y
    y_ = math.sin(math.radians(angle)) * point.x + math.cos(math.radians(angle)) * point.y
    return carla.Vector3D(x_, y_, point.z)


def find_nearby_actors(ego_vehicle, actors, actor_type="*traffic_light*", th=10.0):
    """
    Find all actors of a certain type that are close to the vehicle

    :return: list of actors
    """
    result = list()
    actors = actors.filter(actor_type)

    for actor in actors:
        trigger = actor.trigger_volume
        actor.get_transform().transform(trigger.location)
        dist = trigger.location.distance(ego_vehicle.get_location())

        a = np.sqrt(
            trigger.extent.x ** 2 + trigger.extent.y ** 2 + trigger.extent.z ** 2
        )

        b = np.sqrt(
            ego_vehicle.bounding_box.extent.x ** 2
            + ego_vehicle.bounding_box.extent.y ** 2
            + ego_vehicle.bounding_box.extent.z ** 2
        )

        s = a + b + th
        if dist <= s:
            result.append(actor)

    return result

# def get_nearby_actors(vehicle, actors, pixels_per_meter=5.5, size=512, radius=5):
#     result = list()
#
#     transform = vehicle.get_transform()
#     pos = transform.location
#     theta = np.radians(90 + transform.rotation.yaw)
#
#     # R is used to rotate the points from the world coordinate system to the vehicle's coordinate system
#     R = np.array([[np.cos(theta), -np.sin(theta)], [np.sin(theta), np.cos(theta)]])
#
#     for actor in actors:
#         delta = actor.get_transform().location - pos
#
#         target = R.T.dot([delta.x, delta.y])
#         target *= pixels_per_meter  # scaled by pixels_per_meter to convert from world units to pixels
#         # adjusted to be in the frame of a 2D image of size size x size pixels
#         # by adding half the size to both coordinates.
#         target += size // 2
#
#         if min(target) < 0 or max(target) >= size:
#             continue
#
#         trigger = actor.trigger_volume
#         actor.get_transform().transform(trigger.location)
#         dist = trigger.location.distance(vehicle.get_location())
#
#         # calculates the sum of the radii of the bounding spheres of the trigger volume (a) and the vehicle (b).
#         # If the distance between the vehicle and the light's trigger volume is greater than this sum,
#         # the light is considered too far away and is not added to the result list.
#         a = np.sqrt(
#             trigger.extent.x ** 2 + trigger.extent.y ** 2 + trigger.extent.z ** 2
#         )
#
#         b = np.sqrt(
#             vehicle.bounding_box.extent.x ** 2
#             + vehicle.bounding_box.extent.y ** 2
#             + vehicle.bounding_box.extent.z ** 2
#         )
#
#         if dist > a + b:
#             continue
#
#         result.append(actor)
#
#     return result
