import pandas as pd

from xaiMetrics.data.cnndm.SummEval.evaluation.summ_eval.bert_score_metric import BertScoreMetric
from xaiMetrics.metrics.wrappers.BertScore import BertScore

# Short script to read in a json file with Summaries and References from the paired file of SummEval. This file is generated following the instructions given
# here: https://github.com/Yale-LILY/SummEval
# @article{fabbri2020summeval,
#  title={SummEval: Re-evaluating Summarization Evaluation},
#  author={Fabbri, Alexander R and Kry{\'s}ci{\'n}ski, Wojciech and McCann, Bryan and Xiong, Caiming and Socher, Richard and Radev, Dragomir},
#  journal={arXiv preprint arXiv:2007.12626},
#  year={2020}
#}

summ_df = pd.read_json("model_annotations.aligned.paired.jsonl", lines=True)

def sum_dict(dicts):
    r = {}
    r["coherence"] = sum([d["coherence"] for d in dicts])/len(dicts)
    r["consistency"] = sum([d["consistency"] for d in dicts])/len(dicts)
    r["fluency"] = sum([d["fluency"] for d in dicts])/len(dicts)
    r["relevance"] = sum([d["relevance"] for d in dicts])/len(dicts)
    return r

summ_df["expert_avg"] = summ_df["expert_annotations"].apply(sum_dict)
summ_df["REF"] = summ_df["references"]
summ_df["HYP"] = summ_df["decoded"]

summ_df.to_json("BS_out")
