/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.meteor.aligner;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.zip.GZIPInputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParaphraseTransducer {
    private State reference = new State();
    private ArrayList<int[]> paraphrase = new ArrayList();
    private int nextIdx = 0;
    private Hashtable<String, Integer> vocab = new Hashtable();
    private int nextWord = 0;

    private int map(String string) {
        Integer n = this.vocab.get(string);
        if (n == null) {
            n = new Integer(this.nextWord++);
            this.vocab.put(string, n);
        }
        return n;
    }

    public ParaphraseTransducer(URL uRL) {
        try {
            String string;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new GZIPInputStream(uRL.openStream()), "UTF-8"));
            while ((string = bufferedReader.readLine()) != null) {
                StringTokenizer stringTokenizer = new StringTokenizer(bufferedReader.readLine());
                int[] nArray = new int[stringTokenizer.countTokens()];
                int n = 0;
                while (stringTokenizer.hasMoreTokens()) {
                    nArray[n] = this.map(stringTokenizer.nextToken());
                    ++n;
                }
                stringTokenizer = new StringTokenizer(bufferedReader.readLine());
                int[] nArray2 = new int[stringTokenizer.countTokens()];
                int n2 = 0;
                while (stringTokenizer.hasMoreTokens()) {
                    nArray2[n2] = this.map(stringTokenizer.nextToken());
                    ++n2;
                }
                this.reference.addPath(nArray, 0, this.nextIdx++);
                this.paraphrase.add(nArray2);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new RuntimeException("Error: file not found (" + uRL + ")");
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public int translate(String string) {
        Integer n = this.vocab.get(string);
        if (n == null) {
            return -1;
        }
        return n;
    }

    public int[] translate(String[] stringArray) {
        int[] nArray = new int[stringArray.length];
        int n = 0;
        for (String string : stringArray) {
            nArray[n++] = this.translate(string);
        }
        return nArray;
    }

    public int[] translate(ArrayList<String> arrayList) {
        int[] nArray = new int[arrayList.size()];
        int n = 0;
        for (String string : arrayList) {
            nArray[n++] = this.translate(string);
        }
        return nArray;
    }

    public int[] getReferencePaths(int[] nArray, int n) {
        return this.reference.getPaths(nArray, n);
    }

    public int[] getParaphrase(int n) {
        return this.paraphrase.get(n);
    }

    private class State {
        private Hashtable<Integer, State> trans = new Hashtable(0);
        private int[] emit = new int[0];

        public void addPath(int[] nArray, int n, int n2) {
            if (n == nArray.length) {
                this.emit = Arrays.copyOf(this.emit, this.emit.length + 1);
                this.emit[this.emit.length - 1] = n2;
                return;
            }
            int n3 = nArray[n];
            State state = this.trans.get(n3);
            if (state == null) {
                state = new State();
                this.trans.put(n3, state);
            }
            state.addPath(nArray, n + 1, n2);
        }

        public int[] getPaths(int[] nArray, int n) {
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            State state = this;
            for (int i = 0; i < nArray.length - n && (state = state.trans.get(nArray[n + i])) != null; ++i) {
                if (state.emit == null) continue;
                for (int n2 : state.emit) {
                    arrayList.add(i + 1);
                    arrayList.add(n2);
                }
            }
            int[] nArray2 = new int[arrayList.size()];
            for (int i = 0; i < arrayList.size(); ++i) {
                nArray2[i] = (Integer)arrayList.get(i);
            }
            return nArray2;
        }
    }
}

