import time, threading

elapsed_time_lock = threading.Lock()
elapsed_time = 0


def add_elapsed_time(delta):
    with elapsed_time_lock:
        global elapsed_time
        elapsed_time += delta


def clear_elapsed_time():
    with elapsed_time_lock:
        global elapsed_time
        elapsed_time = 0


def get_elapsed_time():
    with elapsed_time_lock:
        return elapsed_time


def wrap_client_completion(real_client_completion):
    def f(client, **kwargs):
        start_time = time.time()
        r = real_client_completion(client, **kwargs)
        end_time = time.time()
        add_elapsed_time(end_time - start_time)
        return r

    return f
